/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Throwable e) {
            try {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (address.isLoopbackAddress() || address instanceof Inet6Address) continue;
                        return address;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return InetAddress.getByName("127.0.0.1");
        }
    }
}

