/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class GeneralUtils {
    private static final String REGEX_URLHTML = "<A HREF=\"(.+?)\">(.+?)</A>";

    public static String replaceAll(String str, String from_str, String replacement) {
        StringBuffer res = null;
        int pos = 0;
        while (true) {
            int p1;
            if ((p1 = str.indexOf(from_str, pos)) == -1) {
                if (res == null) {
                    return str;
                }
                res.append(str.substring(pos));
                return res.toString();
            }
            if (res == null) {
                res = new StringBuffer(str.length() * 2);
            }
            if (p1 > pos) {
                res.append(str.substring(pos, p1));
            }
            res.append(replacement);
            pos = p1 + from_str.length();
        }
    }

    public static String replaceAll(String str, String[] from_strs, String[] to_strs) {
        StringBuffer res = null;
        int pos = 0;
        while (true) {
            int min_match_pos = Integer.MAX_VALUE;
            int match_index = -1;
            for (int i = 0; i < from_strs.length; ++i) {
                int pt = str.indexOf(from_strs[i], pos);
                if (pt == -1 || pt >= min_match_pos) continue;
                min_match_pos = pt;
                match_index = i;
            }
            if (match_index == -1) {
                if (res == null) {
                    return str;
                }
                res.append(str.substring(pos));
                return res.toString();
            }
            if (res == null) {
                res = new StringBuffer(str.length() * 2);
            }
            if (min_match_pos > pos) {
                res.append(str.substring(pos, min_match_pos));
            }
            res.append(to_strs[match_index]);
            pos = min_match_pos + from_strs[match_index].length();
        }
    }

    public static String stripOutHyperlinks(String message) {
        return Pattern.compile(REGEX_URLHTML, 2).matcher(message).replaceAll("$2");
    }

    public static String[] splitQuotedTokens(String str) {
        ArrayList<String> bits = new ArrayList<String>();
        char quote = ' ';
        boolean escape = false;
        boolean bit_contains_quotes = false;
        String bit = "";
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isWhitespace(c)) {
                c = ' ';
            }
            if (escape) {
                bit = bit + c;
                escape = false;
                continue;
            }
            if (c == '\\') {
                escape = true;
                continue;
            }
            if (c == '\"' || c == '\'' && (i == 0 || chars[i - 1] != '\\')) {
                if (quote == ' ') {
                    bit_contains_quotes = true;
                    quote = c;
                    continue;
                }
                if (quote == c) {
                    quote = ' ';
                    continue;
                }
                bit = bit + c;
                continue;
            }
            if (quote == ' ') {
                if (c == ' ') {
                    if (bit.length() <= 0 && !bit_contains_quotes) continue;
                    bit_contains_quotes = false;
                    bits.add(bit);
                    bit = "";
                    continue;
                }
                bit = bit + c;
                continue;
            }
            bit = bit + c;
        }
        if (quote != ' ') {
            bit = bit + quote;
        }
        if (bit.length() > 0 || bit_contains_quotes) {
            bits.add(bit);
        }
        return bits.toArray(new String[bits.size()]);
    }
}

