/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteSet<T> {
    private volatile Set<T> set = new HashSet<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T o) {
        Set<T> set = this.set;
        synchronized (set) {
            HashSet<T> new_set = new HashSet<T>(this.set);
            new_set.add(o);
            this.set = new_set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T o) {
        Set<T> set = this.set;
        synchronized (set) {
            HashSet<T> new_set = new HashSet<T>(this.set);
            boolean res = new_set.remove(o);
            this.set = new_set;
            return res;
        }
    }

    public boolean contains(T o) {
        return this.set.contains(o);
    }

    public int size() {
        return this.set.size();
    }

    public Iterator<T> iterator() {
        return new CopyOnWriteSetIterator(this.set.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyOnWriteSetIterator
    implements Iterator<T> {
        private Iterator<T> it;
        private T last;

        protected CopyOnWriteSetIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteSet.this.remove(this.last);
        }
    }
}

