/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionManagerImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.IOException;
import java.security.Signature;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;

public class SubscriptionBodyImpl {
    private static final int SIMPLE_ID_LENGTH = 10;
    private SubscriptionManagerImpl manager;
    private String name;
    private boolean is_public;
    private byte[] public_key;
    private int version;
    private int az_version;
    private String json;
    private Map singleton_details;
    private byte[] hash;
    private byte[] sig;
    private int sig_data_size;
    private Map map;

    protected static byte[] encode(byte[] hash, int version, int size) {
        int hash_len = hash.length;
        byte[] result = new byte[hash_len + 4 + 4];
        System.arraycopy(hash, 0, result, 0, hash_len);
        System.arraycopy(SubscriptionImpl.intToBytes(version), 0, result, hash_len, 4);
        System.arraycopy(SubscriptionImpl.intToBytes(size), 0, result, hash_len + 4, 4);
        return result;
    }

    protected static byte[] sign(byte[] private_key, byte[] hash, int version, int size) throws Exception {
        Signature signature = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPrivkey(private_key));
        signature.update(SubscriptionBodyImpl.encode(hash, version, size));
        return signature.sign();
    }

    protected static boolean verify(byte[] public_key, byte[] hash, int version, int size, byte[] sig) {
        try {
            Signature signature = CryptoECCUtils.getSignature(CryptoECCUtils.rawdataToPubkey(public_key));
            signature.update(SubscriptionBodyImpl.encode(hash, version, size));
            return signature.verify(sig);
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    protected static byte[] deriveShortID(byte[] public_key, Map singleton_details) {
        if (singleton_details != null) {
            return SubscriptionBodyImpl.deriveSingletonShortID(singleton_details);
        }
        byte[] hash = new SHA1Simple().calculateHash(public_key);
        byte[] short_id = new byte[10];
        System.arraycopy(hash, 0, short_id, 0, 10);
        return short_id;
    }

    protected static byte[] deriveSingletonShortID(Map singleton_details) {
        byte[] short_id = new byte[10];
        byte[] explicit_sid = new SHA1Simple().calculateHash((byte[])singleton_details.get("key"));
        System.arraycopy(explicit_sid, 0, short_id, 0, 10);
        return short_id;
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl _manager, SubscriptionImpl _subs) throws SubscriptionException {
        this.manager = _manager;
        try {
            File vuze_file = this.manager.getVuzeFile(_subs);
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(vuze_file.getAbsolutePath());
            if (vf == null) {
                throw new IOException("Failed to load vuze file '" + vuze_file + "'");
            }
            this.load(vf.getComponents()[0].getContent(), false);
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl _manager, Map _map) throws IOException {
        this.manager = _manager;
        this.load(_map, true);
    }

    protected void load(Map _map, boolean _verify) throws IOException {
        this.map = _map;
        this.hash = (byte[])this.map.get("hash");
        this.sig = (byte[])this.map.get("sig");
        Long l_size = (Long)this.map.get("size");
        Map details = (Map)this.map.get("details");
        if (details == null || this.hash == null || this.sig == null || l_size == null) {
            throw new IOException("Invalid subscription - details missing");
        }
        this.sig_data_size = l_size.intValue();
        this.name = new String((byte[])details.get("name"), "UTF-8");
        this.public_key = (byte[])details.get("public_key");
        this.version = ((Long)details.get("version")).intValue();
        this.is_public = ((Long)details.get("is_public")).intValue() == 1;
        this.json = new String((byte[])details.get("json"), "UTF-8");
        this.singleton_details = (Map)details.get("sin_details");
        Long l_az_version = (Long)details.get("az_version");
        int n = this.az_version = l_az_version == null ? 1 : l_az_version.intValue();
        if (_verify) {
            byte[] contents = BEncoder.encode(details);
            byte[] actual_hash = new SHA1Simple().calculateHash(contents);
            if (!Arrays.equals(actual_hash, this.hash)) {
                HashMap details_copy = new HashMap(details);
                details_copy.remove("az_version");
                contents = BEncoder.encode(details_copy);
                actual_hash = new SHA1Simple().calculateHash(contents);
            }
            if (!Arrays.equals(actual_hash, this.hash)) {
                throw new IOException("Hash mismatch");
            }
            if (this.sig_data_size != contents.length) {
                throw new IOException("Signature data length mismatch");
            }
            if (!SubscriptionBodyImpl.verify(this.public_key, this.hash, this.version, this.sig_data_size, this.sig)) {
                throw new IOException("Signature verification failed");
            }
        }
    }

    protected SubscriptionBodyImpl(SubscriptionManagerImpl _manager, String _name, boolean _is_public, String _json_content, byte[] _public_key, int _version, int _az_version, Map _singleton_details) throws IOException {
        this.manager = _manager;
        this.name = _name;
        this.is_public = _is_public;
        this.public_key = _public_key;
        this.version = _version;
        this.az_version = _az_version;
        this.json = _json_content;
        this.singleton_details = _singleton_details;
        this.map = new HashMap();
        HashMap<String, Object> details = new HashMap<String, Object>();
        this.map.put("details", details);
        details.put("name", this.name.getBytes("UTF-8"));
        details.put("is_public", new Long(this.is_public ? 1L : 0L));
        details.put("public_key", this.public_key);
        details.put("version", new Long(this.version));
        details.put("az_version", new Long(this.az_version));
        details.put("json", _json_content.getBytes("UTF-8"));
        if (this.singleton_details != null) {
            details.put("sin_details", this.singleton_details);
        }
    }

    protected void updateDetails(SubscriptionImpl subs, Map details) throws IOException {
        this.is_public = subs.isPublic();
        this.version = subs.getVersion();
        this.az_version = subs.getAZVersion();
        this.name = subs.getName();
        details.put("name", this.name.getBytes("UTF-8"));
        details.put("is_public", new Long(this.is_public ? 1L : 0L));
        details.put("version", new Long(this.version));
        details.put("az_version", new Long(this.az_version));
        if (this.json != null) {
            details.put("json", this.json.getBytes("UTF-8"));
        }
        if (this.singleton_details != null) {
            details.put("sin_details", this.singleton_details);
        }
    }

    protected String getName() {
        return this.name;
    }

    protected byte[] getPublicKey() {
        return this.public_key;
    }

    public byte[] getShortID() {
        return SubscriptionBodyImpl.deriveShortID(this.public_key, this.singleton_details);
    }

    protected boolean isPublic() {
        return this.is_public;
    }

    protected String getJSON() {
        return this.json;
    }

    protected Map getSingletonDetails() {
        return this.singleton_details;
    }

    protected void setJSON(String _json) {
        this.json = _json;
    }

    protected int getVersion() {
        return this.version;
    }

    protected int getAZVersion() {
        return this.az_version;
    }

    protected byte[] getHash() {
        return this.hash;
    }

    protected byte[] getSig() {
        return this.sig;
    }

    protected int getSigDataSize() {
        return this.sig_data_size;
    }

    protected void writeVuzeFile(SubscriptionImpl subs) throws SubscriptionException {
        try {
            File file = this.manager.getVuzeFile(subs);
            Map details = (Map)this.map.get("details");
            this.updateDetails(subs, details);
            byte[] contents = BEncoder.encode(details);
            byte[] new_hash = new SHA1Simple().calculateHash(contents);
            byte[] old_hash = (byte[])this.map.get("hash");
            if (old_hash != null && !Arrays.equals(old_hash, new_hash)) {
                HashMap details_copy = new HashMap(details);
                details_copy.remove("az_version");
                contents = BEncoder.encode(details_copy);
                new_hash = new SHA1Simple().calculateHash(contents);
            }
            if (old_hash == null || !Arrays.equals(old_hash, new_hash)) {
                byte[] private_key = subs.getPrivateKey();
                if (private_key == null) {
                    throw new SubscriptionException("Only the originator of a subscription can modify it");
                }
                this.map.put("size", new Long(contents.length));
                try {
                    this.map.put("hash", new_hash);
                    this.map.put("sig", SubscriptionBodyImpl.sign(private_key, new_hash, this.version, contents.length));
                }
                catch (Throwable e) {
                    throw new SubscriptionException("Crypto failed: " + Debug.getNestedExceptionMessage(e));
                }
            }
            File backup_file = null;
            if (file.exists()) {
                backup_file = new File(file.getParent(), file.getName() + ".bak");
                backup_file.delete();
                if (!file.renameTo(backup_file)) {
                    throw new SubscriptionException("Backup failed");
                }
            }
            try {
                VuzeFile vf = VuzeFileHandler.getSingleton().create();
                vf.addComponent(16, this.map);
                vf.write(file);
                this.hash = new_hash;
                this.sig = (byte[])this.map.get("sig");
                this.sig_data_size = contents.length;
            }
            catch (Throwable e) {
                if (backup_file != null) {
                    backup_file.renameTo(file);
                }
                throw new SubscriptionException("File write failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
        catch (Throwable e) {
            this.rethrow(e);
        }
    }

    protected void rethrow(Throwable e) throws SubscriptionException {
        if (e instanceof SubscriptionException) {
            throw (SubscriptionException)e;
        }
        throw new SubscriptionException("Operation failed", e);
    }
}

