/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.rssgen;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

public class RSSGeneratorPlugin
extends WebPlugin {
    public static final String PLUGIN_NAME = "Local RSS etc.";
    public static final int DEFAULT_PORT = 6905;
    public static final String DEFAULT_ACCESS = "all";
    private static volatile RSSGeneratorPlugin singleton;
    private static boolean loaded;
    private static Properties defaults;
    private static Map<String, Provider> providers;
    private HyperlinkParameter test_param;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        Class<RSSGeneratorPlugin> clazz = RSSGeneratorPlugin.class;
        synchronized (RSSGeneratorPlugin.class) {
            String rss_access;
            Integer rss_port;
            if (loaded) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            loaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            File root_dir = new File(SystemProperties.getUserPath() + "rss");
            if (!root_dir.exists()) {
                root_dir.mkdir();
            }
            if (COConfigurationManager.getBooleanParameter("rss.internal.migrated", false)) {
                rss_port = COConfigurationManager.getIntParameter("rss.internal.config.port", 6905);
                rss_access = COConfigurationManager.getStringParameter("rss.internal.config.access", DEFAULT_ACCESS);
            } else {
                boolean local;
                int port = COConfigurationManager.getIntParameter("Plugin.default.device.rss.port", 6905);
                rss_port = port;
                if (port != 6905) {
                    COConfigurationManager.setParameter("rss.internal.config.port", port);
                }
                String string = rss_access = (local = COConfigurationManager.getBooleanParameter("Plugin.default.device.rss.localonly", true)) ? "local" : DEFAULT_ACCESS;
                if (!rss_access.equals(DEFAULT_ACCESS)) {
                    COConfigurationManager.setParameter("rss.internal.config.access", rss_access);
                }
                COConfigurationManager.setParameter("rss.internal.migrated", true);
            }
            defaults.put("Enable", new Boolean(COConfigurationManager.getBooleanParameter("Plugin.default.device.rss.enable", false)));
            defaults.put("Disablable", new Boolean(true));
            defaults.put("Port", rss_port);
            defaults.put("Access", rss_access);
            defaults.put("Root Dir", root_dir.getAbsolutePath());
            defaults.put("DefaultEnableKeepAlive", new Boolean(true));
            defaults.put("DefaultHideResourceConfig", new Boolean(true));
            defaults.put("PairingSID", "rss");
            defaults.put("DefaultConfigModelParams", new String[]{"root", "rss"});
            return;
        }
    }

    public static RSSGeneratorPlugin getSingleton() {
        return singleton;
    }

    public RSSGeneratorPlugin() {
        super(defaults);
    }

    public String getURL() {
        return this.getProtocol() + "://127.0.0.1:" + this.getPort() + "/";
    }

    protected void setupServer() {
        super.setupServer();
        if (this.test_param != null) {
            this.test_param.setEnabled(this.isPluginEnabled());
            this.test_param.setHyperlink(this.getURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProvider(String name, Provider provider2) {
        Map<String, Provider> map = providers;
        synchronized (map) {
            providers.put(name, provider2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterProvider(String name) {
        Map<String, Provider> map = providers;
        synchronized (map) {
            providers.remove(name);
        }
    }

    public void initialize(PluginInterface pi) throws PluginException {
        singleton = this;
        pi.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
        super.initialize(pi);
    }

    protected void initStage(int num) {
        if (num == 1) {
            BasicPluginConfigModel config = this.getConfigModel();
            this.test_param = config.addHyperlinkParameter2("rss.internal.test.url", "");
            this.test_param.setEnabled(this.isPluginEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        Provider provider2;
        String url = request2.getURL();
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        if (url.length() == 0 || url.charAt(0) == '?') {
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(response.getOutputStream(), "UTF-8"));
            pw.println("<HTML><HEAD><TITLE>Vuze Feeds etc.</TITLE></HEAD><BODY>");
            Map<String, Provider> map = providers;
            synchronized (map) {
                for (Map.Entry<String, Provider> entry : providers.entrySet()) {
                    Provider provider3 = entry.getValue();
                    if (!provider3.isEnabled()) continue;
                    String name = entry.getKey();
                    pw.println("<LI><A href=\"" + URLEncoder.encode(name, "UTF-8") + "\">" + name + "</A></LI>");
                }
            }
            pw.println("</BODY></HTML>");
            pw.flush();
            return true;
        }
        int pos = url.indexOf(47);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        Map<String, Provider> map = providers;
        synchronized (map) {
            provider2 = providers.get(url);
        }
        if (provider2 != null && provider2.isEnabled() && provider2.generate(request2, response)) {
            return true;
        }
        response.setReplyStatus(404);
        return true;
    }

    static {
        defaults = new Properties();
        providers = new TreeMap<String, Provider>();
    }

    public static interface Provider
    extends TrackerWebPageGenerator {
        public boolean isEnabled();
    }
}

