/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerDatabase;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.LightHashMap;

public class PeerExchangerItem {
    public static final int MAX_PEERS_PER_VOLLEY = 50;
    private static final int MAX_KNOWN_PER_PEER = 500;
    private final PeerDatabase parent_db;
    private final PeerItem base_peer;
    private final LinkedHashSet<PeerItem> connections_added = new LinkedHashSet();
    private final LinkedHashSet<PeerItem> connections_dropped = new LinkedHashSet();
    private final Map<PeerItem, Object> connected_peers = new LightHashMap<PeerItem, Object>();
    private final AEMonitor peers_mon = new AEMonitor("PeerConnectionItem");
    private boolean maintain_peers_state = true;
    private final Helper helper;

    protected PeerExchangerItem(PeerDatabase parent_db, PeerItem peer, Helper helper) {
        this.parent_db = parent_db;
        this.base_peer = peer;
        this.helper = helper;
    }

    protected PeerItem getBasePeer() {
        return this.base_peer;
    }

    protected Helper getHelper() {
        return this.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedPeer(PeerItem peer) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            int max_cache_size = PeerUtils.MAX_CONNECTIONS_PER_TORRENT;
            if (max_cache_size < 1 || max_cache_size > 500) {
                max_cache_size = 500;
            }
            if (this.connected_peers.size() < max_cache_size) {
                this.connected_peers.put(peer, null);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropConnectedPeer(PeerItem peer) {
        try {
            this.peers_mon.enter();
            this.connected_peers.remove(peer);
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyAdded(PeerItem peer_connection) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            if (!this.connections_dropped.contains(peer_connection)) {
                if (!this.connections_added.contains(peer_connection)) {
                    this.connections_added.add(peer_connection);
                }
            } else {
                this.connections_dropped.remove(peer_connection);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDropped(PeerItem peer_connection) {
        try {
            this.peers_mon.enter();
            if (!this.maintain_peers_state) {
                return;
            }
            if (!this.connections_added.contains(peer_connection)) {
                if (!this.connections_dropped.contains(peer_connection)) {
                    this.connections_dropped.add(peer_connection);
                }
            } else {
                this.connections_added.remove(peer_connection);
            }
        }
        finally {
            this.peers_mon.exit();
        }
    }

    public void seedStatusChanged() {
        this.parent_db.seedStatusChanged(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getNewlyAddedPeerConnections() {
        try {
            this.peers_mon.enter();
            if (this.connections_added.isEmpty()) {
                PeerItem[] peerItemArray = null;
                return peerItemArray;
            }
            int num_to_send = this.connections_added.size() > 50 ? 50 : this.connections_added.size();
            PeerItem[] peers = new PeerItem[num_to_send];
            Iterator it = this.connections_added.iterator();
            for (int i = 0; i < num_to_send; ++i) {
                peers[i] = (PeerItem)it.next();
                it.remove();
            }
            PeerItem[] peerItemArray = peers;
            return peerItemArray;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getNewlyDroppedPeerConnections() {
        try {
            this.peers_mon.enter();
            if (this.connections_dropped.isEmpty()) {
                PeerItem[] peerItemArray = null;
                return peerItemArray;
            }
            int num_to_send = this.connections_dropped.size() > 50 ? 50 : this.connections_dropped.size();
            PeerItem[] peers = new PeerItem[num_to_send];
            Iterator it = this.connections_dropped.iterator();
            for (int i = 0; i < num_to_send; ++i) {
                peers[i] = (PeerItem)it.next();
                it.remove();
            }
            PeerItem[] peerItemArray = peers;
            return peerItemArray;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableStateMaintenance() {
        try {
            this.peers_mon.enter();
            this.maintain_peers_state = false;
            this.connections_added.clear();
            this.connections_dropped.clear();
            this.connected_peers.clear();
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableStateMaintenance() {
        try {
            this.peers_mon.enter();
            if (this.maintain_peers_state) {
                return;
            }
            this.maintain_peers_state = true;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isConnectedToPeer(PeerItem peer) {
        try {
            this.peers_mon.enter();
            boolean bl = this.connected_peers.containsKey(peer);
            return bl;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerItem[] getConnectedPeers() {
        try {
            this.peers_mon.enter();
            PeerItem[] peers = new PeerItem[this.connected_peers.size()];
            this.connected_peers.keySet().toArray(peers);
            PeerItem[] peerItemArray = peers;
            return peerItemArray;
        }
        finally {
            this.peers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.parent_db.deregisterPeerConnection(this.base_peer);
        try {
            this.peers_mon.enter();
            this.connections_added.clear();
            this.connections_dropped.clear();
            this.connected_peers.clear();
        }
        finally {
            this.peers_mon.exit();
        }
    }

    public static interface Helper {
        public boolean isSeed();
    }
}

