/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging;

import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import java.util.Map;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class MessagingUtil {
    public static DirectByteBuffer convertPayloadToBencodedByteStream(Map payload, byte alloc_id) {
        byte[] raw_payload;
        try {
            raw_payload = BEncoder.encode(payload);
        }
        catch (Throwable t) {
            Debug.out(t);
            raw_payload = new byte[]{};
        }
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer(alloc_id, raw_payload.length);
        buffer.put((byte)11, raw_payload);
        buffer.flip((byte)11);
        return buffer;
    }

    public static Map convertBencodedByteStreamToPayload(DirectByteBuffer stream, int min_size, String id) throws MessageException {
        if (stream == null) {
            throw new MessageException("[" + id + "] decode error: stream == null");
        }
        if (stream.remaining((byte)11) < min_size) {
            throw new MessageException("[" + id + "] decode error: stream.remaining[" + stream.remaining((byte)11) + "] < " + min_size);
        }
        byte[] raw = new byte[stream.remaining((byte)11)];
        stream.get((byte)11, raw);
        try {
            Map result = BDecoder.decode(raw);
            stream.returnToPool();
            return result;
        }
        catch (Throwable t) {
            throw new MessageException("[" + id + "] payload stream b-decode error: " + t.getMessage());
        }
    }
}

