/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterSwitcher
implements TransportHelperFilter {
    private TransportHelperFilter current_reader;
    private TransportHelperFilter current_writer;
    private TransportHelperFilter first_filter;
    private TransportHelperFilter second_filter;
    private int read_rem;
    private int write_rem;
    private ByteBuffer read_insert;

    public TransportHelperFilterSwitcher(TransportHelperFilter _filter1, TransportHelperFilter _filter2, int _switch_read, int _switch_write) {
        this.first_filter = _filter1;
        this.second_filter = _filter2;
        this.read_rem = _switch_read;
        this.write_rem = _switch_write;
        this.current_reader = this.read_rem <= 0 ? this.second_filter : this.first_filter;
        this.current_writer = this.write_rem <= 0 ? this.second_filter : this.first_filter;
    }

    public TransportHelperFilterSwitcher(TransportHelperFilter _filter1, TransportHelperFilter _filter2, ByteBuffer _read_insert) {
        this.first_filter = _filter1;
        this.second_filter = _filter2;
        this.read_insert = _read_insert;
        this.current_reader = this.read_rem <= 0 ? this.second_filter : this.first_filter;
        this.current_writer = this.write_rem <= 0 ? this.second_filter : this.first_filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        block12: {
            int[] limits;
            long total_written;
            block11: {
                total_written = 0L;
                if (this.current_writer == this.second_filter) break block12;
                limits = new int[buffers.length];
                int to_write = this.write_rem;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    limits[i] = buffer.limit();
                    int rem = buffer.remaining();
                    if (rem > to_write) {
                        buffer.limit(buffer.position() + to_write);
                        to_write = 0;
                        continue;
                    }
                    to_write -= rem;
                }
                total_written = this.current_writer.write(buffers, array_offset, length);
                if (total_written > 0L) break block11;
                long l = total_written;
                Object var12_11 = null;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
                return l;
            }
            try {
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
                throw throwable;
            }
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer buffer = buffers[i];
                buffer.limit(limits[i]);
            }
            this.write_rem = (int)((long)this.write_rem - total_written);
            if (this.write_rem == 0) {
                if (this.current_writer.hasBufferedWrite()) {
                    return total_written;
                }
                this.current_writer = this.second_filter;
            } else {
                return total_written;
            }
        }
        return total_written += this.current_writer.write(buffers, array_offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        block16: {
            long read;
            int[] limits;
            long total_read;
            block15: {
                total_read = 0L;
                if (this.read_insert != null) {
                    int pos_before = this.read_insert.position();
                    for (int i = array_offset; i < array_offset + length; ++i) {
                        ByteBuffer buffer = buffers[i];
                        int space = buffer.remaining();
                        if (space <= 0) continue;
                        if (space < this.read_insert.remaining()) {
                            int old_limit = this.read_insert.limit();
                            this.read_insert.limit(this.read_insert.position() + space);
                            buffer.put(this.read_insert);
                            this.read_insert.limit(old_limit);
                        } else {
                            buffer.put(this.read_insert);
                        }
                        if (!this.read_insert.hasRemaining()) break;
                    }
                    total_read = this.read_insert.position() - pos_before;
                    if (this.read_insert.hasRemaining()) {
                        return total_read;
                    }
                    this.read_insert = null;
                }
                if (this.current_reader == this.second_filter) break block16;
                limits = new int[buffers.length];
                int to_read = this.read_rem;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    limits[i] = buffer.limit();
                    int rem = buffer.remaining();
                    if (rem > to_read) {
                        buffer.limit(buffer.position() + to_read);
                        to_read = 0;
                        continue;
                    }
                    to_read -= rem;
                }
                read = this.current_reader.read(buffers, array_offset, length);
                if (read > 0L) break block15;
                long l = total_read;
                Object var13_15 = null;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
                return l;
            }
            try {
                total_read += read;
                Object var13_16 = null;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer buffer = buffers[i];
                    buffer.limit(limits[i]);
                }
                throw throwable;
            }
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer buffer = buffers[i];
                buffer.limit(limits[i]);
            }
            this.read_rem = (int)((long)this.read_rem - read);
            if (this.read_rem == 0) {
                this.current_reader = this.second_filter;
            } else {
                return total_read;
            }
        }
        return total_read += this.current_reader.read(buffers, array_offset, length);
    }

    public boolean hasBufferedWrite() {
        return this.current_writer.hasBufferedWrite();
    }

    public boolean hasBufferedRead() {
        return this.read_insert != null || this.current_reader.hasBufferedRead();
    }

    public TransportHelper getHelper() {
        return this.second_filter.getHelper();
    }

    public void setTrace(boolean on) {
        this.first_filter.setTrace(on);
        this.second_filter.setTrace(on);
    }

    public boolean isEncrypted() {
        return this.current_reader.isEncrypted() || this.current_writer.isEncrypted();
    }

    public String getName(boolean verbose) {
        return this.second_filter.getName(verbose);
    }
}

