/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;

public class LWSDownload
implements Download {
    private LightWeightSeed lws;
    private TRTrackerAnnouncer announcer;
    private DownloadAnnounceResultImpl announce_result;
    private Map user_data = new HashMap();
    private Map torrent_attributes = new HashMap();
    private DownloadScrapeResult scrape_result = new DownloadScrapeResult(){

        public Download getDownload() {
            return LWSDownload.this;
        }

        public int getResponseType() {
            return LWSDownload.this.announce_result.getResponseType() == 1 ? 1 : 2;
        }

        public int getSeedCount() {
            return LWSDownload.this.announce_result.getSeedCount();
        }

        public int getNonSeedCount() {
            int seeds = this.getSeedCount();
            int reported = LWSDownload.this.announce_result.getReportedPeerCount();
            int min_peers = reported - seeds;
            int peers = LWSDownload.this.announce_result.getNonSeedCount();
            if (peers < min_peers) {
                peers = min_peers;
            }
            return peers;
        }

        public long getScrapeStartTime() {
            return 0L;
        }

        public void setNextScrapeStartTime(long nextScrapeStartTime) {
        }

        public long getNextScrapeStartTime() {
            return 0L;
        }

        public String getStatus() {
            if (this.getResponseType() == 1) {
                return "OK";
            }
            return LWSDownload.this.announce_result.getError();
        }

        public URL getURL() {
            return LWSDownload.this.announce_result.getURL();
        }
    };

    protected LWSDownload(LightWeightSeed _lws, TRTrackerAnnouncer _announcer) {
        this.lws = _lws;
        this.announcer = _announcer;
        this.announce_result = new DownloadAnnounceResultImpl(this, this.announcer.getLastResponse());
    }

    public int getState() {
        return 5;
    }

    public int getSubState() {
        return 5;
    }

    public String getErrorStateDetails() {
        return "";
    }

    public void setFlag(long flag, boolean value) {
        this.notSupported();
    }

    public boolean getFlag(long flag) {
        return false;
    }

    public long getFlags() {
        return 0L;
    }

    public int getIndex() {
        return 0;
    }

    public File[] calculateDefaultPaths(boolean for_moving) {
        return new File[2];
    }

    public SaveLocationChange calculateDefaultDownloadLocation() {
        return null;
    }

    public boolean isInDefaultSaveDir() {
        return false;
    }

    public Torrent getTorrent() {
        return this.lws.getTorrent();
    }

    public void initialize() throws DownloadException {
    }

    public void start() throws DownloadException {
    }

    public void startDownload(boolean force) {
    }

    public void stopDownload() {
    }

    public void stop() throws DownloadException {
    }

    public void stopAndQueue() throws DownloadException {
    }

    public void restart() throws DownloadException {
    }

    public void pause() {
    }

    public void resume() {
    }

    public void recheckData() throws DownloadException {
    }

    public boolean isStartStopLocked() {
        return false;
    }

    public boolean isForceStart() {
        return true;
    }

    public void setForceStart(boolean forceStart) {
    }

    public int getPriority() {
        return 0;
    }

    public void setPriority(int priority) {
    }

    public boolean isPriorityLocked() {
        return false;
    }

    public boolean isPaused() {
        return false;
    }

    public String getName() {
        return this.lws.getName();
    }

    public String getTorrentFileName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttribute(TorrentAttribute attribute) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            return (String)this.torrent_attributes.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(TorrentAttribute attribute, String value) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            this.torrent_attributes.put(attribute, value);
        }
    }

    public String[] getListAttribute(TorrentAttribute attribute) {
        TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
        if (attribute == tm.getAttribute("Networks")) {
            return new String[]{"Public"};
        }
        if (attribute == tm.getAttribute("PeerSources")) {
            return new String[]{"DHT"};
        }
        return null;
    }

    public void setListAttribute(TorrentAttribute attribute, String[] value) {
        this.notSupported();
    }

    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        this.notSupported();
    }

    public Map getMapAttribute(TorrentAttribute attribute) {
        return null;
    }

    public void setIntAttribute(TorrentAttribute name, int value) {
        this.notSupported();
    }

    public int getIntAttribute(TorrentAttribute name) {
        return 0;
    }

    public void setLongAttribute(TorrentAttribute name, long value) {
        this.notSupported();
    }

    public long getLongAttribute(TorrentAttribute name) {
        return 0L;
    }

    public void setBooleanAttribute(TorrentAttribute name, boolean value) {
        this.notSupported();
    }

    public boolean getBooleanAttribute(TorrentAttribute name) {
        return false;
    }

    public boolean hasAttribute(TorrentAttribute name) {
        return false;
    }

    public void addAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    public void removeAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    public String getCategoryName() {
        return null;
    }

    public void setCategory(String sName) {
        this.notSupported();
    }

    public void remove() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public boolean isRemoved() {
        return false;
    }

    public int getPosition() {
        return 0;
    }

    public long getCreationTime() {
        return 0L;
    }

    public void setPosition(int newPosition) {
        this.notSupported();
    }

    public void moveUp() {
        this.notSupported();
    }

    public void moveDown() {
        this.notSupported();
    }

    public void moveTo(int position) {
        this.notSupported();
    }

    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.announcer.setAnnounceResult(result);
    }

    public void setScrapeResult(DownloadScrapeResult result) {
    }

    public DownloadAnnounceResult getLastAnnounceResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.announce_result;
    }

    public DownloadScrapeResult getLastScrapeResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.scrape_result;
    }

    public DownloadActivationEvent getActivationState() {
        return null;
    }

    public DownloadStats getStats() {
        return null;
    }

    public boolean isPersistent() {
        return false;
    }

    public void setMaximumDownloadKBPerSecond(int kb) {
        this.notSupported();
    }

    public int getMaximumDownloadKBPerSecond() {
        return 0;
    }

    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isComplete(boolean bIncludeDND) {
        return true;
    }

    public boolean isChecking() {
        return false;
    }

    public String getSavePath() {
        return "";
    }

    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    public boolean canMoveDataFiles() {
        return false;
    }

    public void moveTorrentFile(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    public void renameDownload(String name) throws DownloadException {
        this.notSupported();
    }

    public PeerManager getPeerManager() {
        return null;
    }

    public DiskManager getDiskManager() {
        return null;
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return null;
    }

    public DiskManagerFileInfo getDiskManagerFileInfo(int i) {
        return null;
    }

    public void requestTrackerAnnounce() {
    }

    public void requestTrackerAnnounce(boolean immediate) {
    }

    public void requestTrackerScrape(boolean immediate) {
    }

    public void addListener(DownloadListener l) {
    }

    public void removeListener(DownloadListener l) {
    }

    public void addCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    public void removeCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    public void addTrackerListener(DownloadTrackerListener l) {
    }

    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
    }

    public void removeTrackerListener(DownloadTrackerListener l) {
    }

    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    public void addActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    public void removeActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    public void addPeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    public void removePeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    public int getSeedingRank() {
        return 0;
    }

    public void setSeedingRank(int rank) {
        this.notSupported();
    }

    public void addPropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    public void removePropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    public byte[] getDownloadPeerId() {
        return null;
    }

    public boolean isMessagingEnabled() {
        return true;
    }

    public void setMessagingEnabled(boolean enabled) {
    }

    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserData(Object key) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserData(Object key, Object data) {
        Map map = this.user_data;
        synchronized (map) {
            this.user_data.put(key, data);
        }
    }

    public void changeLocation(SaveLocationChange slc) throws DownloadException {
        this.notSupported();
    }

    protected void notSupported() {
        Debug.out("Not Supported");
    }
}

