/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerChannelImpl;

public class DownloadManagerEnhancer {
    public static final int TICK_PERIOD = 1000;
    private static DownloadManagerEnhancer singleton;
    private AzureusCore core;
    private Map<DownloadManager, EnhancedDownloadManager> download_map = new HashMap<DownloadManager, EnhancedDownloadManager>();
    private Set<HashWrapper> pause_set = new HashSet<HashWrapper>();
    private boolean progressive_enabled;
    private AtomicLong progressive_active_counter = new AtomicLong();

    public static synchronized DownloadManagerEnhancer initialise(AzureusCore core) {
        if (singleton == null) {
            singleton = new DownloadManagerEnhancer(core);
        }
        return singleton;
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(AzureusCore _core) {
        this.core = _core;
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(DownloadManager dm) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(DownloadManager dm) {
                EnhancedDownloadManager edm;
                Map map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    edm = (EnhancedDownloadManager)DownloadManagerEnhancer.this.download_map.remove(dm);
                }
                if (edm != null) {
                    edm.destroy();
                }
            }

            public void destroyInitiated() {
                DownloadManagerEnhancer.this.resume();
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        });
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            public boolean receive(String name, Map values) {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int query(String name, Map values) {
                if (name.equals("az3.downloadmanager.stream.eta")) {
                    Object hash = values.get("hash");
                    byte[] b_hash = null;
                    if (hash instanceof String) {
                        String hash_str = (String)hash;
                        b_hash = hash_str.length() == 32 ? Base32.decode(hash_str) : ByteFormatter.decodeString(hash_str);
                    }
                    if (b_hash != null) {
                        DownloadManagerEnhancer.this.getEnhancedDownload(b_hash);
                    }
                    Map map = DownloadManagerEnhancer.this.download_map;
                    synchronized (map) {
                        for (EnhancedDownloadManager edm : DownloadManagerEnhancer.this.download_map.values()) {
                            if (b_hash != null) {
                                long eta;
                                byte[] d_hash = edm.getHash();
                                if (d_hash == null || !Arrays.equals(b_hash, d_hash)) continue;
                                if (edm.getDownloadManager().isDownloadComplete(false)) {
                                    return 0;
                                }
                                if (!edm.supportsProgressiveMode()) {
                                    return Integer.MIN_VALUE;
                                }
                                if (!edm.getProgressiveMode()) {
                                    edm.setProgressiveMode(true);
                                }
                                if ((eta = edm.getProgressivePlayETA()) > Integer.MAX_VALUE) {
                                    return Integer.MAX_VALUE;
                                }
                                return (int)eta;
                            }
                            if (!edm.getProgressiveMode()) continue;
                            long eta = edm.getProgressivePlayETA();
                            if (eta > Integer.MAX_VALUE) {
                                return Integer.MAX_VALUE;
                            }
                            return (int)eta;
                        }
                    }
                }
                return Integer.MIN_VALUE;
            }
        });
        SimpleTimer.addPeriodicEvent("DownloadManagerEnhancer:speedChecker", 1000L, new TimerEventPerformer(){
            private int tick_count;
            private long last_inactive_marker = -1L;

            public void perform(TimerEvent event2) {
                ++this.tick_count;
                long current_marker = DownloadManagerEnhancer.this.progressive_active_counter.get();
                if (this.last_inactive_marker == current_marker) {
                    return;
                }
                List downloads = DownloadManagerEnhancer.this.core.getGlobalManager().getDownloadManagers();
                boolean is_active = false;
                for (int i = 0; i < downloads.size(); ++i) {
                    DownloadManager download = (DownloadManager)downloads.get(i);
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(download);
                    if (edm == null || !edm.updateStats(this.tick_count)) continue;
                    is_active = true;
                }
                if (!is_active) {
                    this.last_inactive_marker = current_marker;
                }
            }
        });
        DiskManagerChannelImpl.addListener(new DiskManagerChannelImpl.channelCreateListener(){

            public void channelCreated(DiskManagerChannel channel2) {
                try {
                    EnhancedDownloadManager edm = DownloadManagerEnhancer.this.getEnhancedDownload(PluginCoreUtils.unwrap(channel2.getFile().getDownload()));
                    if (edm == null) {
                        return;
                    }
                    if (edm.getDownloadManager().isDownloadComplete(true)) {
                        return;
                    }
                    if (!edm.getProgressiveMode() && edm.supportsProgressiveMode()) {
                        Debug.out("Enabling progressive mode for '" + edm.getName() + "' due to external stream");
                        edm.setProgressiveMode(true);
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
    }

    protected void progressiveActivated() {
        this.progressive_active_counter.incrementAndGet();
    }

    protected AzureusCore getCore() {
        return this.core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pause(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (this.pause_set.contains(hw)) {
                    return;
                }
                this.pause_set.add(hw);
            }
            dm.pause();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            HashWrapper hw = torrent.getHashWrapper();
            Set<HashWrapper> set = this.pause_set;
            synchronized (set) {
                if (!this.pause_set.remove(hw)) {
                    return;
                }
            }
            dm.resume();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resume() {
        HashSet<HashWrapper> copy;
        Set<HashWrapper> set = this.pause_set;
        synchronized (set) {
            copy = new HashSet<HashWrapper>(this.pause_set);
            this.pause_set.clear();
        }
        GlobalManager gm = this.core.getGlobalManager();
        for (HashWrapper hw : copy) {
            DownloadManager dm = gm.getDownloadManager(hw);
            if (dm == null) continue;
            dm.resume();
        }
    }

    protected void prepareForProgressiveMode(DownloadManager dm, boolean active) {
        if (active) {
            GlobalManager gm = this.core.getGlobalManager();
            List dms = gm.getDownloadManagers();
            for (DownloadManager this_dm : dms) {
                int state;
                if (this_dm == dm || this_dm.isDownloadComplete(false) || (state = this_dm.getState()) != 50 && state != 75) continue;
                this.pause(this_dm);
            }
            if (dm.isPaused()) {
                dm.resume();
            }
        } else {
            this.resume();
        }
    }

    public EnhancedDownloadManager getEnhancedDownload(byte[] hash) {
        DownloadManager dm = this.core.getGlobalManager().getDownloadManager(new HashWrapper(hash));
        if (dm == null) {
            return null;
        }
        return this.getEnhancedDownload(dm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager manager) {
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null) {
            return null;
        }
        DownloadManager dm2 = manager.getGlobalManager().getDownloadManager(torrent);
        if (dm2 != manager) {
            return null;
        }
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager res = this.download_map.get(manager);
            if (res == null) {
                res = new EnhancedDownloadManager(this, manager);
                this.download_map.put(manager, res);
            }
            return res;
        }
    }

    public boolean isProgressiveAvailable() {
        if (this.progressive_enabled) {
            return true;
        }
        PluginInterface ms_pi = this.core.getPluginManager().getPluginInterfaceByID("azupnpav", true);
        if (ms_pi != null) {
            this.progressive_enabled = true;
        }
        return this.progressive_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager findDownloadManager(String hash) {
        Map<DownloadManager, EnhancedDownloadManager> map = this.download_map;
        synchronized (map) {
            for (DownloadManager dm : this.download_map.keySet()) {
                String thisHash;
                TOTorrent torrent = dm.getTorrent();
                if (!PlatformTorrentUtils.isContent(torrent, true) || !hash.equals(thisHash = PlatformTorrentUtils.getContentHash(torrent))) continue;
                return dm;
            }
        }
        return null;
    }
}

