/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.CustomDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public abstract class StandardDialog
extends CustomDialog
implements ActionListener {
    private JButton btnOK;
    private JButton btnCancel;
    private boolean canceled = true;

    protected StandardDialog(Frame parentFrame) {
        super(parentFrame);
    }

    protected StandardDialog(Dialog parentDialog) {
        super(parentDialog);
    }

    protected void init() {
        this.setModal(true);
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setBounds(this.getFrameBounds());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.canceled = true;
        }
        super.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.btnOK) {
            this.doOk();
        } else if (source == this.btnCancel) {
            this.doCancel();
        }
    }

    protected JButton getOKButton() {
        return this.btnOK;
    }

    protected JButton getCancelButton() {
        return this.btnCancel;
    }

    protected void doOk() {
        this.canceled = false;
        this.setVisible(false);
    }

    protected void doCancel() {
        this.setVisible(false);
    }

    protected void setupControls() {
        this.btnOK = new JButton(Messages.getMessages().getString("ButtonOK"));
        this.btnCancel = new JButton(Messages.getMessages().getString("ButtonCancel"));
    }

    protected void setupEventHandlers() {
        this.btnOK.addActionListener(this);
        this.btnCancel.addActionListener(this);
    }

    protected void setupComponent() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.addScreenContent(panel);
        contentPane.add((Component)panel, this.isFillVertical() ? "Center" : "First");
        contentPane.add((Component)this.createButtonPanel(), "Last");
        this.getRootPane().setDefaultButton(this.btnOK);
    }

    protected abstract void addScreenContent(JPanel var1);

    protected abstract boolean isFillVertical();

    protected JPanel createButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add((Component)this.createButtonBox(), "Center");
        return panel;
    }

    protected JComponent createButtonBox() {
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOK, this.btnCancel}, 0);
        Box buttonBox = new Box(2);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(box);
        return buttonBox;
    }

    protected boolean checkTextField(JTextComponent textField) {
        if (textField.getText().trim().length() == 0) {
            this.showMissingMessage(textField);
            return false;
        }
        return true;
    }

    protected void showMissingMessage(JComponent missingComponent) {
        GUIHelper.showMessage(this.getOwner(), Messages.getMessages().getString("EnterInformation"), 2);
        missingComponent.requestFocus();
    }

    protected JPanel createBorderPanel(String title, LayoutManager layoutManager) {
        return this.createBorderPanel(title, layoutManager, 0);
    }

    protected JPanel createBorderPanel(String title, LayoutManager layoutManager, int border) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(border, border, border, border)));
        if (layoutManager != null) {
            panel.setLayout(layoutManager);
        }
        return panel;
    }
}

