/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileResourceBundle
extends ResourceBundle {
    private LinkedHashMap<String, String> properties = new LinkedHashMap();

    public FileResourceBundle(File file, ResourceBundle parent) throws IOException {
        String line;
        this.setParent(parent);
        FileInputStream fis = new FileInputStream(file);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
        while ((line = br.readLine()) != null) {
            int index;
            if (line.trim().startsWith("#") || (index = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, index);
            if (key.charAt(0) == '\ufeff') {
                key = key.substring(1);
            }
            String value = line.substring(index + 1);
            value = this.replaceLineBreaks(value);
            this.properties.put(key, value);
        }
        fis.close();
    }

    public LinkedHashMap<String, String> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Enumeration<String> getKeys() {
        Set<String> keySet = this.properties.keySet();
        if (this.parent != null) {
            LinkedHashSet<String> copiedSet = new LinkedHashSet<String>();
            copiedSet.addAll(keySet);
            keySet = copiedSet;
            Enumeration<String> en = this.parent.getKeys();
            while (en.hasMoreElements()) {
                keySet.add(en.nextElement());
            }
        }
        return Collections.enumeration(keySet);
    }

    @Override
    protected Object handleGetObject(@NotNull String key) {
        return this.properties.get(key);
    }

    private String replaceLineBreaks(String string) {
        int index;
        while ((index = string.indexOf("\\n")) > -1) {
            string = string.substring(0, index) + "\n" + string.substring(index + 2);
        }
        while ((index = string.indexOf("\u00a5n")) > -1) {
            string = string.substring(0, index) + "\n" + string.substring(index + 2);
        }
        return string;
    }
}

