/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.launcher;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.LegacySplashScreen;
import com.install4j.runtime.launcher.WindowChecker;
import java.awt.Frame;
import java.awt.Window;

public class AwtAndFxWindowChecker
extends WindowChecker {
    public AwtAndFxWindowChecker(Runnable runnable) {
        super(runnable);
    }

    @Override
    protected boolean checkExecute() {
        return AwtAndFxWindowChecker.hasVisibleWindows();
    }

    public static boolean hasVisibleWindows() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (frame.isShowing()) {
                return true;
            }
            if (!AwtAndFxWindowChecker.checkWindows(frame.getOwnedWindows())) continue;
            return true;
        }
        boolean javaFxWindowShown = VersionSpecificHelper.isJavaFxWindowShown();
        if (javaFxWindowShown) {
            GUIHelper.setLafUnconditional();
        }
        return javaFxWindowShown;
    }

    private static boolean checkWindows(Window[] windows) {
        for (Window window : windows) {
            if (!(window instanceof LegacySplashScreen) && window.isShowing()) {
                return true;
            }
            if (!AwtAndFxWindowChecker.checkWindows(window.getOwnedWindows())) continue;
            return true;
        }
        return false;
    }
}

