/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.RegistryView;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.platform.JVMLocator;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class WinJVMLocator {
    private static final String REGKEY_JAVASOFT_JDK = "SOFTWARE\\JavaSoft\\Java Development Kit";
    private static final String REGKEY_JAVASOFT_JRE = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String REGVAL_JAVAHOME = "JavaHome";
    public static final String[] JDK_FILES = new String[]{"bin/javac.exe", "lib/tools.jar"};
    public static final String JAVA_EXECUTABLE = "bin/java.exe";

    public static Collection<JVMLocator.JVMLocation> getJVMLocations(boolean bothBitnesses) {
        HashSet<JVMLocator.JVMLocation> ret = new HashSet<JVMLocator.JVMLocation>();
        if (bothBitnesses) {
            WinJVMLocator.addJvms(ret, RegistryView.BIT32);
            WinJVMLocator.addJvms(ret, RegistryView.BIT64);
        } else {
            WinJVMLocator.addJvms(ret, RegistryView.DEFAULT);
        }
        ret.addAll(WinJVMLocator.getSharedJRES());
        return ret;
    }

    private static void addJvms(Set<JVMLocator.JVMLocation> ret, RegistryView registryView) {
        ret.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JDK, registryView));
        for (JVMLocator.JVMLocation jvmLocation : ret) {
            jvmLocation.setJDK(true);
        }
        ret.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JRE, registryView));
    }

    private static Collection<JVMLocator.JVMLocation> getSharedJRES() {
        ArrayList<JVMLocator.JVMLocation> ret = new ArrayList<JVMLocator.JVMLocation>();
        File parent = new File(FolderInfo.getCommonFilesDirectory(), "i4j_jres");
        File[] files = parent.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory() || file.getName().startsWith("jre") || !new File(file, "bin\\java.exe").exists()) continue;
                JVMLocator.JVMLocation jvmLocation = new JVMLocator.JVMLocation();
                jvmLocation.setJavaHome(file);
                jvmLocation.setVersion(file.getName());
                ret.add(jvmLocation);
            }
        }
        return ret;
    }

    private static Collection<JVMLocator.JVMLocation> getFromKey(String keyName, RegistryView registryView) {
        HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation> ret = new HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation>();
        String[] subKeys = WinRegistry.getSubKeyNames(RegistryRoot.HKEY_LOCAL_MACHINE, keyName, registryView);
        if (subKeys != null) {
            for (String subKey : subKeys) {
                String javaHome;
                JVMLocator.JVMLocation jvmLocation = new JVMLocator.JVMLocation();
                jvmLocation.setVersion(subKey);
                Object javaHomeObject = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, keyName + "\\" + subKey, REGVAL_JAVAHOME, registryView);
                if (javaHomeObject == null || !(javaHomeObject instanceof String) || !new File((javaHome = (String)javaHomeObject) + "\\bin\\java.exe").exists()) continue;
                jvmLocation.setJavaHome(new File(javaHome));
                JVMLocator.JVMLocation oldJvmLocation = (JVMLocator.JVMLocation)ret.get(jvmLocation);
                if (oldJvmLocation != null && oldJvmLocation.getVersion().length() >= jvmLocation.getVersion().length()) continue;
                ret.put(jvmLocation, jvmLocation);
            }
        }
        return ret.values();
    }
}

