/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.windows.WinProcesses;
import com.install4j.runtime.installer.platform.win32.Common;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class Misc {
    private static Properties envVarCache = null;
    private static Properties lookupEnvVarCache = null;
    private static final String REBOOT_PARAMETER = "__i4j_reboot";
    public static final int TERMINATE_FAILURE = 0;
    public static final int TERMINATE_SUCCESS = 1;
    public static final int TERMINATE_WAIT_FAILURE = 2;
    public static final int TERMINATE_TIMEOUT = 3;
    private static final char[] ESCAPE_VERIFICATION = new char[]{' ', '\t', '<', '>'};

    public static void reboot() {
        try {
            new ProcessBuilder(System.getProperty("exe4j.moduleName"), REBOOT_PARAMETER).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static WinProcesses.Info[] getRunningProcesses() {
        String[] modules = Misc.getRunningModules0(false);
        if (modules == null) {
            return null;
        }
        WinProcesses.Info[] processInfos = new WinProcesses.Info[modules.length];
        for (int i = 0; i < modules.length; ++i) {
            String value = modules[i];
            int pos = value.indexOf(32);
            int processId = pos > 0 ? Integer.parseInt(value.substring(0, pos)) : 0;
            String moduleName = value.substring(pos + 1);
            processInfos[i] = new WinProcesses.Info(processId, moduleName);
        }
        return processInfos;
    }

    public static Properties getenv() {
        if (envVarCache == null) {
            envVarCache = new Properties();
            lookupEnvVarCache = new Properties();
            String[] envVarPairs = Misc.getEnvVarPairs0();
            if (envVarPairs != null) {
                for (String pair : envVarPairs) {
                    int equalPos = pair.indexOf(61);
                    if (equalPos <= 0) continue;
                    String key = pair.substring(0, equalPos);
                    String value = pair.substring(equalPos + 1);
                    envVarCache.setProperty(key, value);
                    lookupEnvVarCache.setProperty(key.toUpperCase(), value);
                }
            }
        }
        return envVarCache;
    }

    public static String getenv(String key) {
        Misc.getenv();
        return lookupEnvVarCache.getProperty(key.toUpperCase());
    }

    public static void broadcastSettingChange() {
        Misc.broadcastSettingChange0();
    }

    public static long getPhysicalMemory() {
        return Misc.getPhysicalMemory0();
    }

    public static long getFreeDiskSpace(File checkFile) {
        if (!checkFile.isDirectory() && (checkFile = checkFile.getParentFile()) == null) {
            return -1L;
        }
        return Misc.getFreeDiskSpace0(checkFile.getAbsolutePath());
    }

    public static boolean moveWithDelayUntilReboot(File source, File destination) {
        return Misc.moveWithDelayUntilReboot0(source.getAbsolutePath(), destination == null ? null : destination.getAbsolutePath());
    }

    public static void toFront() {
        Misc.toFront0();
    }

    public static int terminateProcesses(int[] processIds, boolean force, int wmCloseTimeout) {
        return Misc.terminateProcesses0(processIds, force, wmCloseTimeout);
    }

    public static String getWindowTitle(int processId) {
        return Misc.getWindowTitle0(processId);
    }

    private static boolean needsEscaping(String arg) {
        for (char escapeChar : ESCAPE_VERIFICATION) {
            if (arg.indexOf(escapeChar) < 0) continue;
            return true;
        }
        return false;
    }

    public static void launch(String ... command) throws IOException {
        StringBuilder commandLine = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            String currentArg = command[i];
            if (commandLine.length() > 0) {
                commandLine.append(" ");
            }
            if (i == 0 || Misc.needsEscaping(currentArg)) {
                commandLine.append("\"").append(currentArg).append("\"");
                continue;
            }
            commandLine.append(currentArg);
        }
        if (!new File(command[0]).isFile()) {
            throw new IOException("not a file " + command[0]);
        }
        int ret = Misc.launch0(command[0], commandLine.toString());
        if (ret != 0) {
            throw new IOException("error launching " + command[0] + ", commandLine: " + commandLine + ", error " + ret);
        }
    }

    private static native void reboot0();

    private static native String[] getRunningModules0(boolean var0);

    private static native String[] getEnvVarPairs0();

    private static native void broadcastSettingChange0();

    private static native long getPhysicalMemory0();

    private static native long getFreeDiskSpace0(String var0);

    private static native boolean moveWithDelayUntilReboot0(String var0, String var1);

    private static native void toFront0();

    private static native int terminateProcesses0(int[] var0, boolean var1, int var2);

    private static native String getWindowTitle0(int var0);

    private static native int launch0(String var0, String var1);

    static {
        Common.init();
    }
}

