/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.registry.DeleteRegistryItemAction;
import com.install4j.runtime.beans.actions.registry.SetRegistryValueAction;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FileAssociations {
    private static final String FILE_EXTS_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts";
    private static final String USER_CHOICE_KEY = "UserChoice";
    private static final String PROGID = "Progid";
    private static final String ALTERNATIVE_HANDLER = "AlternativeHandler";

    public static List<SystemInstallOrUninstallAction> create(String extension, String description, File iconFile, File executable, String additionalParameters) throws UserCanceledException {
        String commandKeyName;
        boolean success;
        SystemInstallOrUninstallAction action;
        String commandKeyName2;
        Object value;
        ArrayList<SystemInstallOrUninstallAction> ret = new ArrayList<SystemInstallOrUninstallAction>();
        ContextInt context = ContextImpl.getSingleContextInt();
        String internalNameBase = executable.getName().substring(0, executable.getName().length() - 4);
        if (additionalParameters == null) {
            additionalParameters = "";
        }
        if (additionalParameters.length() > 0) {
            additionalParameters = additionalParameters + " ";
        }
        String executableValue = "\"" + executable.getAbsolutePath() + "\" " + additionalParameters + "\"%1\"";
        int index = 0;
        String internalName = internalNameBase;
        while (!(!WinRegistry.keyExists(RegistryRoot.HKEY_CLASSES_ROOT, internalName) || (value = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, commandKeyName2 = internalName + "\\shell\\open\\command", "")) instanceof String && value.equals(executableValue) && FileAssociations.isEqualEntry(description, iconFile, internalName))) {
            internalName = internalNameBase + " " + ++index;
        }
        Logger.getInstance().info(null, "using internal name " + internalName);
        Object previousValue = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, "");
        if (previousValue != null && !previousValue.toString().equals(internalName) && WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, ALTERNATIVE_HANDLER) == null) {
            action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, extension, ALTERNATIVE_HANDLER, previousValue, true);
            success = ((SetRegistryValueAction)action).execute(context);
            Logger.getInstance().log(null, "setting alternative handler", success);
            ret.add(action);
        }
        if (!(success = (action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, extension, "", internalName, true)).execute(context))) {
            Logger.getInstance().error(null, "error setting internal name");
        }
        ret.add(action);
        action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, internalName, "", description, true);
        success = action.execute(context);
        if (!success) {
            Logger.getInstance().error(null, "error adding internal name");
        }
        ret.add(action);
        if (iconFile != null) {
            String iconKeyName = internalName + "\\DefaultIcon";
            action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, iconKeyName, "", iconFile.getAbsolutePath(), true);
            action.execute(context);
            ret.add(action);
        }
        if (!(success = (action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, commandKeyName = internalName + "\\shell\\open\\command", "", executableValue, true)).execute(context))) {
            Logger.getInstance().error(null, "error setting command key");
        }
        ret.add(action);
        if (WinRegistry.keyExists(RegistryRoot.HKEY_CURRENT_USER, FILE_EXTS_KEY)) {
            String keyName = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension;
            action = new SetRegistryValueAction(RegistryRoot.HKEY_CURRENT_USER, keyName, PROGID, internalName, true);
            action.execute(context);
            ret.add(action);
            keyName = keyName + "\\UserChoice";
            action = new DeleteRegistryItemAction(RegistryRoot.HKEY_CURRENT_USER, keyName, "", false);
            action.execute(context);
            ret.add(action);
        }
        Registry.changeNotifyAssociations();
        return ret;
    }

    private static boolean isEqualEntry(String description, File iconFile, String internalName) {
        Object value = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, internalName + "\\DefaultIcon", "");
        if (iconFile == null ? value instanceof String : !iconFile.getAbsolutePath().equals(value)) {
            return false;
        }
        value = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, internalName, "");
        return !(description == null ? value instanceof String : !description.equals(value));
    }

    public static boolean exists(String extension) {
        return WinRegistry.keyExists(RegistryRoot.HKEY_CLASSES_ROOT, extension);
    }

    public static String getExecutable(String extension) {
        StringTokenizer tok;
        Object command;
        String commandKeyName;
        Object internalName;
        if (FileAssociations.exists(extension) && (internalName = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, "")) != null && WinRegistry.keyExists(RegistryRoot.HKEY_CLASSES_ROOT, commandKeyName = internalName.toString() + "\\shell\\open\\command") && (command = WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, commandKeyName, "")) != null && (tok = new StringTokenizer(command.toString(), "\"")).hasMoreTokens()) {
            return tok.nextToken();
        }
        return null;
    }

    public static List<SystemInstallOrUninstallAction> remove(String extension, boolean completely) throws UserCanceledException {
        ArrayList<SystemInstallOrUninstallAction> ret = new ArrayList<SystemInstallOrUninstallAction>();
        try {
            ContextInt context = ContextImpl.getSingleContextInt();
            String internalName = (String)WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, "");
            String previousInternalName = (String)WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, ALTERNATIVE_HANDLER);
            if (previousInternalName == null) {
                previousInternalName = "";
            }
            SetRegistryValueAction action = new SetRegistryValueAction(RegistryRoot.HKEY_CLASSES_ROOT, extension, "", previousInternalName, false);
            action.execute(context);
            ret.add(action);
            if (completely && internalName != null && internalName.trim().length() > 0) {
                Object userAssoc;
                DeleteRegistryItemAction deleteAction = new DeleteRegistryItemAction(RegistryRoot.HKEY_CLASSES_ROOT, internalName, "", false);
                deleteAction.execute(context);
                ret.add(deleteAction);
                if (WinRegistry.getValue(RegistryRoot.HKEY_CLASSES_ROOT, extension, ALTERNATIVE_HANDLER) != null) {
                    deleteAction = new DeleteRegistryItemAction(RegistryRoot.HKEY_CLASSES_ROOT, extension, ALTERNATIVE_HANDLER, false);
                    deleteAction.execute(context);
                    ret.add(deleteAction);
                }
                if ((userAssoc = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension, PROGID)) instanceof String && userAssoc.equals(internalName)) {
                    deleteAction = new DeleteRegistryItemAction(RegistryRoot.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\FileExts\\" + extension, PROGID, true);
                    deleteAction.execute(context);
                    ret.add(deleteAction);
                }
            }
            Registry.changeNotifyAssociations();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

