/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class PipeCommunicationBackend
implements CommunicationBackend {
    private static final String SPAWNED_SUFFIX = ".spawned";
    private static final String LISTENER_SUFFIX = ".listener";
    private DataInputStream is;
    private DataOutputStream os;
    private String baseFile;
    private boolean listener = false;

    private String getWriteFilePath() {
        return this.baseFile + (this.listener ? LISTENER_SUFFIX : SPAWNED_SUFFIX);
    }

    private String getReadFilePath() {
        return this.baseFile + (this.listener ? SPAWNED_SUFFIX : LISTENER_SUFFIX);
    }

    @Override
    public String createListener() {
        try {
            this.listener = true;
            File file = File.createTempFile("i4c", ".com");
            file.deleteOnExit();
            String name = file.getAbsolutePath();
            while (new File(name + LISTENER_SUFFIX).exists() || new File(name + SPAWNED_SUFFIX).exists()) {
                file = File.createTempFile("i4c", ".com");
                file.deleteOnExit();
                name = file.getAbsolutePath();
            }
            this.baseFile = name;
            Execution.executeAndWait(new String[]{"mkfifo", "-m", "0600", this.getReadFilePath(), this.getWriteFilePath()}, null);
            new File(this.getReadFilePath()).deleteOnExit();
            new File(this.getWriteFilePath()).deleteOnExit();
            return name;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean connect(String identifier) {
        if (identifier == null) {
            if (this.baseFile == null) {
                return false;
            }
        } else {
            this.baseFile = identifier;
        }
        return true;
    }

    @Override
    public boolean writeDataBlock(byte[] bytes) {
        try {
            if (this.os == null) {
                this.os = new DataOutputStream(new FileOutputStream(this.getWriteFilePath()));
            }
            this.os.writeInt(bytes.length);
            this.os.flush();
            this.os.write(bytes);
            this.os.flush();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public byte[] readDataBlock() {
        try {
            if (this.is == null) {
                this.is = new DataInputStream(new FileInputStream(this.getReadFilePath()));
            }
            int length = this.is.readInt();
            byte[] ret = new byte[length];
            this.is.readFully(ret);
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

