/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.api.Util;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ProxyHelper;
import com.install4j.runtime.installer.helper.versionspecific.ConsoleAccess;
import com.install4j.runtime.installer.helper.versionspecific.NoHelper;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelperInterface;
import com.install4j.runtime.util.VersionCheck;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;

public abstract class VersionSpecificHelper {
    private static VersionSpecificHelperInterface helper;
    private static final String JAVA7_CLASS_NAME = "com.install4j.runtime.installer.helper.versionspecific.Java17Helper";
    private static ConsoleAccess consoleAccess;

    public static boolean isNoHelper() {
        return helper.getClass().equals(NoHelper.class);
    }

    public static ProxyHostInfo getProxyHostInfo(URL url) {
        return ProxyHelper.getProxyHostInfo(url);
    }

    public static ConsoleAccess getConsoleAccess() {
        if (consoleAccess == null) {
            consoleAccess = helper.createConsoleAccess();
        }
        return consoleAccess;
    }

    public static boolean isSymbolicLink(File file) {
        return helper.isSymbolicLink(file);
    }

    public static File getSymbolicLinkTargetFile(File file) throws IOException {
        return helper.getSymbolicLinkTargetFile(file);
    }

    public static boolean createSymbolicLink(File symLink, File target) {
        try {
            helper.createSymbolicLink(symLink, target);
        }
        catch (IOException e) {
            Logger.getInstance().log(null, e.getMessage(), false);
            return false;
        }
        return true;
    }

    public static String getPosixFilePermissions(File file) throws IOException {
        return helper.getPosixFilePermissions(file);
    }

    public static boolean setPosixFilePermissions(File file, String mode) {
        if (!Util.isWindows()) {
            try {
                helper.setPosixFilePermissions(file, mode);
            }
            catch (Exception e) {
                Logger.getInstance().log(null, "set permissions: " + e.toString(), false);
                return false;
            }
        }
        return true;
    }

    public static boolean setPosixFilePermissions(File file, int mode) {
        if (!Util.isWindows()) {
            try {
                helper.setPosixFilePermissions(file, mode);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean setPosixFilePermissionsRecursive(File dir, String mode) {
        if (!Util.isWindows()) {
            try {
                helper.setPosixFilePermissionsRecursive(dir, mode);
            }
            catch (Exception e) {
                Logger.getInstance().log(null, "set permissions: " + e.toString(), false);
                return false;
            }
        }
        return true;
    }

    public static boolean setOwner(File file, String userAndGroup) {
        try {
            helper.setOwner(file, userAndGroup);
        }
        catch (Exception e) {
            Logger.getInstance().log(null, "set owner: " + e.toString(), false);
            return false;
        }
        return true;
    }

    public static TransformerFactory createTransformerFactory() {
        return helper.createTransformerFactory();
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        return helper.createDocumentBuilderFactory();
    }

    public static UnixFileSystem.FileInformation getFileInformation(File file) throws IOException {
        return helper.getFileInformation(file);
    }

    public static void disablePreferencesLogging() {
        helper.disablePreferencesLogging();
    }

    public static boolean isJavaFxWindowShown() {
        return helper.isJavaFxWindowShown();
    }

    public static boolean canInheritParentHandles() {
        return !VersionSpecificHelper.isNoHelper();
    }

    public static void inheritParentHandle(ProcessBuilder processBuilder, VersionSpecificHelperInterface.StreamType streamType) {
        helper.inheritParentHandle(processBuilder, streamType);
    }

    public static long getContentLength(URLConnection connection) {
        return helper.getContentLength(connection);
    }

    public static ZipFile openZipFile(File file, String encoding) throws IOException {
        return helper.openZipFile(file, encoding);
    }

    public static ZipInputStream createZipInputStream(InputStream in, String encoding) {
        return helper.createZipInputStream(in, encoding);
    }

    static {
        String className = null;
        if (VersionCheck.checkJavaVersionCompatible("1.7", System.getProperty("java.version"))) {
            className = JAVA7_CLASS_NAME;
        } else {
            helper = new NoHelper();
        }
        if (className == null) {
            helper = new NoHelper();
        } else {
            try {
                helper = (VersionSpecificHelperInterface)Class.forName(className).newInstance();
            }
            catch (Throwable e) {
                helper = new NoHelper();
            }
        }
    }
}

