/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class AppleScriptHelper {
    private static final String EVAL_SCRIPT = "evalScript";
    private static ScriptEngine engine;

    private AppleScriptHelper() {
    }

    public static List<Map<String, Object>> getRecords(String script) throws ScriptException {
        return (List)AppleScriptHelper.executeWithReturnValue(script);
    }

    public static synchronized void initEngine() {
        if (engine == null) {
            try {
                ScriptEngineManager mgr = new ScriptEngineManager();
                try {
                    engine = mgr.getEngineByName("AppleScriptEngine");
                }
                catch (Exception e) {
                    engine = mgr.getEngineByName("AppleScript");
                }
                if (engine != null) {
                    ScriptContext context = engine.getContext();
                    Bindings bindings = context.getBindings(100);
                    bindings.put("javax_script_function", (Object)EVAL_SCRIPT);
                }
            }
            catch (Throwable e) {
                Logger.getInstance().log(e);
            }
        }
    }

    public static Object executeWithReturnValue(String script) throws ScriptException {
        try {
            AppleScriptHelper.initEngine();
            if (engine == null) {
                throw new ScriptException("AppleScript engine not found");
            }
            ScriptContext context = engine.getContext();
            Bindings bindings = context.getBindings(100);
            bindings.put("javax_script_function", (Object)EVAL_SCRIPT);
            return engine.eval("on evalScript()\n" + script + "\nend " + EVAL_SCRIPT + "\n", context);
        }
        catch (RuntimeException e) {
            throw new ScriptException(e);
        }
    }

    public static boolean executeScript(String script) {
        try {
            Logger.getInstance().info(null, script);
            File tempFile = File.createTempFile("i4j", ".script");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)), "UTF-8"));
            pw.println(script);
            pw.close();
            StringBuffer output = new StringBuffer();
            boolean ret = Execution.executeAndWait(new String[]{"/usr/bin/osascript", tempFile.getAbsolutePath()}, output);
            tempFile.delete();
            Logger.getInstance().info(null, output.toString());
            return ret;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }

    public static void main(String[] args) throws ScriptException {
        AppleScriptHelper.initEngine();
        System.out.println(AppleScriptHelper.executeWithReturnValue("return \"hello world\""));
    }
}

