/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.DefaultUnattendedProgressInterface;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Locale;

public abstract class UnattendedScreenExecutor
extends AbstractHeadlessScreenExecutor {
    private UnattendedProgressInterface progressInterface;
    private boolean quietOverwrite;
    private int wait;
    private String splash;
    private boolean dialog;
    private Window parentWindow;
    private boolean suppressStdout;
    private boolean detailStdout;

    public UnattendedScreenExecutor(boolean quietOverwrite, int wait, String splash, boolean dialog, Window parentWindow) {
        this.quietOverwrite = quietOverwrite;
        this.wait = wait;
        this.splash = splash;
        this.dialog = dialog;
        this.parentWindow = parentWindow;
        this.suppressStdout = Boolean.getBoolean("install4j.suppressStdout");
        this.detailStdout = Boolean.getBoolean("install4j.detailStdout");
        this.init(splash == null && this.getUnattendedProgressInterfaceProvider() == null);
    }

    private ScriptProperty getUnattendedProgressInterfaceProvider() {
        ScriptProperty unattendedProgressInterfaceProvider = InstallerConfig.getCurrentApplication().getUnattendedProgressInterfaceProvider();
        if (unattendedProgressInterfaceProvider != null && unattendedProgressInterfaceProvider.getValue() != null && unattendedProgressInterfaceProvider.getValue().length() > 0) {
            return unattendedProgressInterfaceProvider;
        }
        return null;
    }

    @Override
    protected ControllerCommand handleScreen(ScreenBeanConfig screenConfig) {
        if (this.wait > 0) {
            try {
                boolean success = false;
                for (int i = 0; i < this.wait; ++i) {
                    if (RunningProcessChecker.checkDefaultRunningLauncher(null)) {
                        success = true;
                        break;
                    }
                    Thread.sleep(1000L);
                }
                if (!success) {
                    System.err.println(Messages.getMessages().getString("UnattendedRunningFailure"));
                    this.getContext().immediateExit(-1);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (UserCanceledException e) {
                // empty catch block
            }
            this.wait = 0;
        }
        Object[] scriptParameters = null;
        Screen screen = screenConfig.getOrInstantiateScreen(false);
        if (screen instanceof FormPanelContainer) {
            FormPanel formPanel = new FormPanel(screenConfig.getFormComponentConfigs(), this.getContext(), false, screen, null);
            ((FormPanelContainer)((Object)screen)).setFormPanel(formPanel, formPanel.getFormEnvironment());
            if (!formPanel.handleUnattended()) {
                return ControllerCommand.CANCEL;
            }
            scriptParameters = new Object[]{formPanel.getFormEnvironment()};
        }
        if (screen.isHidden() || screen.isHiddenForNext()) {
            return null;
        }
        if (!screen.handleUnattended()) {
            return ControllerCommand.CANCEL;
        }
        this.getContext().runBooleanScript(screenConfig.getPreActivationClassName(), screen, scriptParameters);
        return this.runValidationScript(screenConfig, screen, scriptParameters);
    }

    @Override
    public boolean isUnattended() {
        return true;
    }

    @Override
    public boolean isConsole() {
        return false;
    }

    @Override
    public ProgressInterface getProgressInterface() {
        if (this.progressInterface == null) {
            final ScriptProperty unattendedProgressInterfaceProvider = this.getUnattendedProgressInterfaceProvider();
            if (this.splash == null && unattendedProgressInterfaceProvider == null) {
                this.progressInterface = new NullProgressInterface();
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        GUIHelper.setLaF();
                        try {
                            if (unattendedProgressInterfaceProvider != null) {
                                UnattendedScreenExecutor.this.progressInterface = (UnattendedProgressInterface)UnattendedScreenExecutor.this.getContext().runScript(unattendedProgressInterfaceProvider, InstallerConfig.getCurrentApplication(), null);
                            } else {
                                UnattendedScreenExecutor.this.progressInterface = new SplashProgressInterface(UnattendedScreenExecutor.this.splash, false, UnattendedScreenExecutor.this.quietOverwrite, UnattendedScreenExecutor.this, UnattendedScreenExecutor.this.dialog, UnattendedScreenExecutor.this.parentWindow);
                            }
                            UnattendedScreenExecutor.this.progressInterface.setVisible(true);
                        }
                        catch (Exception e) {
                            Util.fatalError(e);
                        }
                    }
                };
                try {
                    GUIHelper.invokeOnEDT(runnable);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.progressInterface = new NullProgressInterface();
                }
            }
        }
        return this.progressInterface;
    }

    @Override
    public void closeWindows() {
        if (this.progressInterface != null) {
            this.progressInterface.setVisible(false);
        }
    }

    @Override
    public void selectLanguage(ReturnToken wakeupToken) {
        String id = null;
        List<LanguageConfig> languages = InstallerConfig.getCurrentInstance().getLanguages();
        String systemLanguageId = Locale.getDefault().getLanguage();
        LanguageConfig language = InstallerConfig.getCurrentInstance().getLanguageById(systemLanguageId);
        if (language != null) {
            id = language.getId();
        } else if (languages.size() > 0) {
            id = languages.get(0).getId();
        }
        wakeupToken.returnToController(id);
    }

    @Override
    protected DummyWizardContext createWizardContext() {
        return new UnattendedWizardContext();
    }

    private class NullProgressInterface
    extends DefaultUnattendedProgressInterface {
        private NullProgressInterface() {
        }

        @Override
        public void setStatusMessage(String message) {
            if (!UnattendedScreenExecutor.this.suppressStdout) {
                ConsoleImpl.getInstance().setStatusMessage(message);
            }
        }

        @Override
        public void setDetailMessage(String message) {
            if (UnattendedScreenExecutor.this.detailStdout) {
                ConsoleImpl.getInstance().setDetailMessage(message);
            }
        }

        @Override
        public void showFailure(String message) {
            ConsoleImpl.getInstance().showFailure(message);
        }

        @Override
        public int askOverwrite(File file) {
            if (UnattendedScreenExecutor.this.quietOverwrite) {
                return 2;
            }
            return 1;
        }
    }

    private class UnattendedWizardContext
    extends DummyWizardContext {
        private UnattendedWizardContext() {
        }

        @Override
        public void setCancelButtonEnabled(boolean enabled) {
            if (UnattendedScreenExecutor.this.progressInterface != null) {
                UnattendedScreenExecutor.this.progressInterface.setCancelButtonEnabled(enabled);
            }
        }

        @Override
        public void setCancelButtonVisible(boolean visible) {
            if (UnattendedScreenExecutor.this.progressInterface != null) {
                UnattendedScreenExecutor.this.progressInterface.setCancelButtonVisible(visible);
            }
        }
    }
}

