/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDisplay
extends JPanel {
    private static final String PROPERTY_XP_INDETERMINATE = "install4j.xpIndeterminate";
    private static boolean JAVA_1_6_AND_HIGHER;
    private JLabel lblStatus;
    private JLabel lblDetail;
    private JProgressBar progressBar;
    private IndeterminateUpdaterThread indeterminateUpdaterThread;
    private GridBagConstraints gc;
    private int percentCompleted = 0;
    private int secondaryPercentCompleted = 0;
    private String lastDetailMessage;
    private boolean progressBarSizeWorkaround;

    public ProgressDisplay() {
        this.setupControls();
        this.setupComponent();
    }

    public void setStatusMessage(final String statusMessage) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.lblStatus.setText(statusMessage.length() == 0 ? " " : statusMessage);
            }
        });
    }

    public void setDetailMessage(final String detailMessage) {
        this.lastDetailMessage = detailMessage;
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.lblDetail.setText(detailMessage.length() == 0 ? " " : detailMessage);
            }
        });
    }

    public void setStatusVisible(final boolean visible) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.lblStatus.setVisible(visible);
            }
        });
    }

    public void setDetailVisible(final boolean visible) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.lblDetail.setVisible(visible);
            }
        });
    }

    public void setPercentCompleted(final int percentCompleted) {
        if (this.percentCompleted == percentCompleted) {
            return;
        }
        this.percentCompleted = percentCompleted <= 100 ? percentCompleted : 100;
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.progressBar.setValue(percentCompleted);
            }
        });
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void setupControls() {
        this.lblStatus = new JLabel(" ");
        this.lblDetail = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
        boolean bl = this.progressBarSizeWorkaround = Boolean.getBoolean("install4j.progressBarWorkaround") || Util.isWindows2012();
        if (this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(new Dimension(100, 15));
        }
    }

    @Override
    public void setEnabled(final boolean enabled) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.setTextLinesEnabled(enabled);
            }
        });
    }

    public void setTextLinesEnabled(final boolean enabled) {
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDisplay.this.lblStatus.setEnabled(enabled);
                ProgressDisplay.this.lblDetail.setEnabled(enabled);
            }
        });
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.add((Component)this.lblStatus, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.lblDetail, this.gc);
        ++this.gc.gridy;
        this.gc.insets.top = 3;
        this.gc.insets.bottom = 3;
        this.add((Component)this.progressBar, this.gc);
        ++this.gc.gridy;
    }

    public void setIndeterminateProgress(final boolean indeterminateProgress) {
        if (!this.isEmulate()) {
            GUIHelper.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDisplay.this.setIndeterminateInternal(indeterminateProgress);
                }
            });
        }
        if (!indeterminateProgress) {
            if (this.indeterminateUpdaterThread == null) {
                return;
            }
            this.indeterminateUpdaterThread.cancel();
            try {
                this.indeterminateUpdaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            GUIHelper.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDisplay.this.setPercentCompleted(ProgressDisplay.this.percentCompleted);
                }
            });
            this.indeterminateUpdaterThread = null;
        } else {
            if (this.indeterminateUpdaterThread != null) {
                return;
            }
            this.indeterminateUpdaterThread = new IndeterminateUpdaterThread();
            this.indeterminateUpdaterThread.start();
        }
    }

    private void setIndeterminateInternal(boolean indeterminateProgress) {
        if (JAVA_1_6_AND_HIGHER && !this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(null);
            if (indeterminateProgress) {
                Dimension size = this.progressBar.getPreferredSize();
                --size.height;
                this.progressBar.setPreferredSize(size);
            }
            this.progressBar.invalidate();
            this.validate();
        }
        this.progressBar.setIndeterminate(indeterminateProgress);
    }

    private boolean isEmulate() {
        return GUIHelper.isWindowsXpLaF() && !Boolean.getBoolean(PROPERTY_XP_INDETERMINATE) && !JAVA_1_6_AND_HIGHER;
    }

    public void activate() {
    }

    public void setSecondaryPercentCompleted(final int percentCompleted) {
        if (this.secondaryPercentCompleted == percentCompleted || percentCompleted < 0) {
            return;
        }
        this.secondaryPercentCompleted = percentCompleted;
        GUIHelper.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ProgressDisplay.this.lblDetail.isVisible()) {
                    ProgressDisplay.this.setDetailVisible(true);
                }
                StringBuilder buffer = new StringBuilder();
                if (ProgressDisplay.this.lastDetailMessage != null && ProgressDisplay.this.lastDetailMessage.trim().length() > 0) {
                    buffer.append(ProgressDisplay.this.lastDetailMessage);
                    buffer.append(' ');
                }
                buffer.append("(");
                buffer.append(percentCompleted);
                buffer.append(" %)");
                ProgressDisplay.this.lblDetail.setText(buffer.toString());
            }
        });
    }

    static {
        String javaVersion = System.getProperty("java.version");
        JAVA_1_6_AND_HIGHER = !javaVersion.startsWith("1.2") && !javaVersion.startsWith("1.3") && !javaVersion.startsWith("1.4") && !javaVersion.startsWith("1.5");
    }

    private class IndeterminateUpdaterThread
    extends Thread {
        private boolean canceled;

        private IndeterminateUpdaterThread() {
        }

        @Override
        public void run() {
            while (!this.canceled) {
                for (int i = 0; i <= 100; i += 5) {
                    final int value = i;
                    if (ProgressDisplay.this.isEmulate()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ProgressDisplay.this.progressBar.setValue(value);
                            }
                        });
                    }
                    try {
                        Thread.sleep(80L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

