/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.VariableResourceBundleWrapper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.impl.HelperResourceBundle;
import com.install4j.runtime.util.DefaultPropertyResourceBundle;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class Messages {
    private static final String LANGUAGES_MESSAGE_PREFIX = "languages.";
    private static VariableResourceBundleWrapper messages = null;
    private static LanguageConfig languageConfig;

    public static void setLanguageConfig(LanguageConfig languageConfig) {
        if (languageConfig == null) {
            throw new IllegalArgumentException("language config cannot be null");
        }
        Messages.languageConfig = languageConfig;
        messages = null;
        GUIHelper.setLanguage(languageConfig.getId());
    }

    public static VariableResourceBundleWrapper getMessages() {
        if (messages == null) {
            messages = HelperCommunication.getInstance().isElevatedHelper() ? new VariableResourceBundleWrapper(new HelperResourceBundle()) : Messages.createMessages(languageConfig);
        }
        return messages;
    }

    public static void setMessages(ResourceBundle messages) {
        Messages.messages = new VariableResourceBundleWrapper(messages);
    }

    public static String format(String pattern, Object ... arguments) {
        pattern = StringUtil.replace(pattern, "'", "''");
        return MessageFormat.format(pattern, arguments);
    }

    public static VariableResourceBundleWrapper createMessages(LanguageConfig languageConfig) {
        try {
            return Messages.createMessagesInternal(languageConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = "Internal error: Could not open message file.";
            if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
                System.err.println(message);
            } else {
                JOptionPane.showMessageDialog(null, message, "install4j Setup", 0, null);
            }
            InstallerUtil.exit(1);
            throw new RuntimeException();
        }
    }

    private static VariableResourceBundleWrapper createMessagesInternal(LanguageConfig languageConfig) throws IOException {
        ResourceBundle messages;
        File defaultMessagesFile = InstallerUtil.getInstallerFile("MessagesDefault");
        ResourceBundle defaultMessages = new FileResourceBundle(defaultMessagesFile, null);
        if (languageConfig == null) {
            messages = defaultMessages;
        } else {
            LanguageConfig principalLanguageConfig = InstallerConfig.getCurrentInstance().getLanguages().get(0);
            defaultMessages = Messages.createResourceBundleWithCustomLocalization(principalLanguageConfig, defaultMessages);
            File messagesFile = InstallerUtil.getInstallerFile(languageConfig.getMessageFile());
            messages = messagesFile.exists() ? new FileResourceBundle(messagesFile, defaultMessages) : defaultMessages;
            messages = Messages.createResourceBundleWithCustomLocalization(languageConfig, messages);
        }
        return new VariableResourceBundleWrapper(messages);
    }

    private static ResourceBundle createResourceBundleWithCustomLocalization(LanguageConfig languageConfig, ResourceBundle messages) throws IOException {
        File customLocalizationFile;
        String customLocalizationFileName = languageConfig.getCustomLocalizationFile();
        if (customLocalizationFileName.trim().length() > 0 && (customLocalizationFile = InstallerUtil.getInstallerFile(customLocalizationFileName)).exists()) {
            messages = customLocalizationFileName.toLowerCase().endsWith("properties") ? DefaultPropertyResourceBundle.create(customLocalizationFile, messages) : new FileResourceBundle(customLocalizationFile, messages);
        }
        return messages;
    }

    public static List<LanguageConfig> sortLanguages(List<LanguageConfig> languages, final ResourceBundle messages) {
        ArrayList<LanguageConfig> sortedList = new ArrayList<LanguageConfig>(languages);
        Collections.sort(sortedList, new Comparator<LanguageConfig>(){

            @Override
            public int compare(LanguageConfig o1, LanguageConfig o2) {
                String name1 = Messages.getLocalizedLanguageName(o1, messages);
                String name2 = Messages.getLocalizedLanguageName(o2, messages);
                return name1.compareTo(name2);
            }
        });
        return sortedList;
    }

    public static String getLocalizedLanguageName(LanguageConfig languageConfig, ResourceBundle messages) {
        String localizedName = null;
        try {
            localizedName = messages.getString(LANGUAGES_MESSAGE_PREFIX + languageConfig.getId());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (localizedName != null) {
            return localizedName;
        }
        return languageConfig.getName();
    }
}

