/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.beans.actions.properties.TextProperties;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.ApplicationBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.VariableEncoding;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UninstallPreviousAction
extends SystemInstallAction {
    public static final String PROP_UPGRADE_UNINSTALL = "install4j.upgradeUninstall";
    public static final String PROP_DONT_UNINSTALL_SERVICES = "install4j.dontUninstallServices";
    private File installationDirectory;
    private boolean onlyIfSameApplicationId = true;
    private boolean uninstallServices = true;
    private Map<String, String> installerVariables = new LinkedHashMap<String, String>();
    private static List<File> logFiles = new ArrayList<File>();

    public static List<File> getLogFiles() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<List<File>>(){

            @Override
            protected List<File> fetchValue(Context context) throws Exception {
                return logFiles;
            }
        });
    }

    public File getInstallationDirectory() {
        return UninstallPreviousAction.replaceVariables(this.installationDirectory);
    }

    public void setInstallationDirectory(File installationDirectory) {
        this.installationDirectory = installationDirectory;
    }

    public boolean isOnlyIfSameApplicationId() {
        return this.onlyIfSameApplicationId;
    }

    public void setOnlyIfSameApplicationId(boolean onlyIfSameApplicationId) {
        this.onlyIfSameApplicationId = onlyIfSameApplicationId;
    }

    public boolean isUninstallServices() {
        return this.uninstallServices;
    }

    public void setUninstallServices(boolean uninstallServices) {
        this.uninstallServices = uninstallServices;
    }

    public Map<String, String> getInstallerVariables() {
        return this.installerVariables;
    }

    public void setInstallerVariables(Map<String, String> installerVariables) {
        this.installerVariables = installerVariables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        try {
            ProgressInterface progressInterface = context.getProgressInterface();
            Logger.getInstance().info(this, "checking running processes");
            if (!RunningProcessChecker.checkDefaultRunningLauncher("AppRunningError")) {
                throw new UserCanceledException();
            }
            Logger.getInstance().info(this, "checking running processes ok");
            File externalInstallationDirectory = this.getInstallationDirectory();
            File installationDirectory = externalInstallationDirectory == null || externalInstallationDirectory.getPath().trim().length() == 0 ? context.getInstallationDirectory() : externalInstallationDirectory;
            InstallerConfig config = InstallerConfig.getCurrentInstance();
            Logger.getInstance().info(this, "getting previous installation id");
            String oldApplicationId = InstallerUtil.getOldApplicationId(installationDirectory);
            if (oldApplicationId != null && (!this.onlyIfSameApplicationId || config.getApplicationId().equals(oldApplicationId))) {
                progressInterface.setStatusMessage(Messages.getMessages().getString("StatusUninstallingPrevious"));
                progressInterface.setIndeterminateProgress(true);
                File varFile = null;
                try {
                    varFile = this.writeVarFile();
                    UninstallerThread uninstallerThread = new UninstallerThread(installationDirectory, context.getInstallationDirectory().getCanonicalFile().equals(installationDirectory.getCanonicalFile()), !this.isUninstallServices(), varFile);
                    Logger.getInstance().info(this, "starting uninstaller");
                    uninstallerThread.start();
                    while (uninstallerThread.isAlive()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!context.isCancelling()) continue;
                        uninstallerThread.interrupt();
                    }
                }
                finally {
                    if (varFile != null && varFile.isFile() && !varFile.delete()) {
                        varFile.deleteOnExit();
                    }
                }
                progressInterface.setIndeterminateProgress(false);
            } else {
                Logger.getInstance().info(this, "no previous installation detected, uninstaller was not started");
            }
            Logger.getInstance().info(this, "finished");
            return true;
        }
        catch (UserCanceledException e) {
            Logger.getInstance().info(this, "user cancelled");
            throw e;
        }
        catch (Throwable t) {
            Logger.getInstance().log(t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writeVarFile() throws IOException {
        File varFile = null;
        if (!this.installerVariables.isEmpty()) {
            TextProperties encodedResponse = new TextProperties();
            for (Map.Entry<String, String> entry : this.installerVariables.entrySet()) {
                VariableEncoding.encodeVariable(encodedResponse, UninstallPreviousAction.replaceVariables(entry.getKey()), UninstallPreviousAction.replaceVariables(entry.getValue()));
            }
            varFile = File.createTempFile("i4j", ".varfile");
            FileOutputStream out = new FileOutputStream(varFile);
            try {
                out.write(encodedResponse.convertToPropertiesString().getBytes());
            }
            finally {
                out.close();
            }
        }
        return varFile;
    }

    private static int fetchLogFiles(final File logFile) {
        return HelperCommunication.getInstance().fetchInt(ExecutionContext.UNELEVATED, new FetchLongAction(){

            @Override
            protected long fetchValue(Context context) throws Exception {
                int index = logFiles.size();
                logFiles.add(logFile);
                return index;
            }
        });
    }

    private class UninstallerThread
    extends Thread {
        private File installationDirectory;
        private boolean upgrade;
        private final boolean dontUninstallServices;
        private final File varFile;

        public UninstallerThread(File installationDirectory, boolean upgrade, boolean dontUninstallServices, File varFile) {
            super("uninstaller waiting thread");
            this.installationDirectory = installationDirectory;
            this.upgrade = upgrade;
            this.dontUninstallServices = dontUninstallServices;
            this.varFile = varFile;
        }

        private List<String> addCommonArguments(List<String> list, File logFile) {
            list.add("-q");
            list.add("-Dinstall4j.alternativeLogfile=" + logFile.getAbsolutePath());
            list.add("-Dinstall4j.upgradeUninstall=" + this.upgrade);
            list.add("-Dinstall4j.dontUninstallServices=" + this.dontUninstallServices);
            if (this.varFile != null) {
                list.add("-varfile");
                if (Util.isWindows()) {
                    list.add(FolderInfo.getShortPathName(this.varFile.getAbsolutePath()));
                } else {
                    list.add(this.varFile.getAbsolutePath());
                }
            }
            return list;
        }

        @Override
        public void run() {
            InstallerConfig oldConfig = InstallerUtil.getOldApplicationConfig(this.installationDirectory);
            if (oldConfig == null) {
                Logger.getInstance().error(this, "did not find old config");
                return;
            }
            try {
                File logFile = File.createTempFile("i4j_log_uninstaller", ".log");
                logFile.deleteOnExit();
                int logFileIndex = UninstallPreviousAction.fetchLogFiles(logFile);
                if (InstallerUtil.isMacOS()) {
                    this.runJavaUninstaller(oldConfig, logFile);
                } else if (InstallerUtil.isWindows()) {
                    File undeletedLogFile = new File("i4j_undel.log.tmp");
                    ArrayList<String> arguments = new ArrayList<String>();
                    arguments.add("-q_i4j_internal");
                    this.addCommonArguments(arguments, logFile);
                    arguments.add("-Dwindel.logfile=" + undeletedLogFile.getAbsolutePath());
                    LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(this.installationDirectory, oldConfig.getUninstallerPath() + ".exe")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
                    Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
                    Logger.getInstance().info(this, "native uninstaller process returned " + returnValue);
                    if (returnValue == null || returnValue == 83) {
                        this.runJavaUninstaller(oldConfig, logFile);
                    } else {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.deleteWindowsUndelFiles(undeletedLogFile);
                    }
                } else {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add("/bin/sh");
                    command.add(new File(this.installationDirectory, oldConfig.getUninstallerPath()).getAbsolutePath());
                    this.addCommonArguments(command, logFile);
                    Process process = new ProcessBuilder(command).directory(new File(this.installationDirectory, "..")).start();
                    try {
                        if (process.waitFor() == 83) {
                            this.runJavaUninstaller(oldConfig, logFile);
                        }
                    }
                    catch (InterruptedException e) {
                        process.destroy();
                    }
                }
                Logger.getInstance().info(this, "see " + Logger.getUninstallPreviousLogFileName(logFileIndex) + " for the log file of the uninstaller");
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void runJavaUninstaller(InstallerConfig config, File logFile) throws IOException {
            Application application;
            String vmParameters = "";
            ApplicationBeanConfig appConfig = config.getApplicationConfigById("uninstaller");
            if (appConfig != null && (application = appConfig.getOrInstantiateApplication(true)) != null) {
                vmParameters = application.getVmParameters();
            }
            File runtimeDir = new File(this.installationDirectory, ".install4j");
            String classpath = new File(runtimeDir, "i4jruntime.jar").getAbsolutePath();
            ArrayList<String> arguments = new ArrayList<String>();
            StringUtil.splitupCommandLine(arguments, vmParameters);
            arguments.add("-cp");
            arguments.add(classpath);
            arguments.add("com.install4j.runtime.installer.Uninstaller");
            this.addCommonArguments(arguments, logFile);
            LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File(System.getProperty("java.home"), "bin/java")).arguments(arguments).workingDirectory(new File(this.installationDirectory, "..")).wait(true);
            Integer returnValue = LaunchHelper.launchApplication(launchDescriptor);
            Logger.getInstance().info(this, "uninstaller process returned " + returnValue);
        }

        private void deleteWindowsUndelFiles(File undeletedLogFile) throws IOException {
            if (undeletedLogFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(undeletedLogFile));
                if (reader.readLine() != null) {
                    String name = reader.readLine();
                    while (name != null) {
                        if (!name.equals("") && !new File(name).delete()) {
                            System.out.println("could not delete " + name);
                        }
                        name = reader.readLine();
                    }
                }
                reader.close();
                undeletedLogFile.delete();
            } else {
                System.out.println(undeletedLogFile + " doesn't exist");
            }
        }
    }
}

