/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.unix;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.IOException;

public class UnixFileSystem {
    public static boolean setMode(int intMode, File destFile) {
        return VersionSpecificHelper.setPosixFilePermissions(destFile, intMode);
    }

    public static boolean setMode(String mode, File destFile) {
        return VersionSpecificHelper.setPosixFilePermissions(destFile, mode);
    }

    public static boolean createLink(String destFileName, File linkFile) {
        return VersionSpecificHelper.createSymbolicLink(linkFile, new File(destFileName));
    }

    public static boolean setOwner(String owner, File file) {
        return VersionSpecificHelper.setOwner(file, owner.trim());
    }

    public static FileInformation getFileInformation(File file) {
        try {
            return VersionSpecificHelper.getFileInformation(file);
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return null;
        }
    }

    public static interface FileInformation {
        public int getMode();

        public String getOwnerInfo();

        public boolean isLink();

        public String getLinkTarget();
    }
}

