/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime;

import com.exe4j.runtime.WinLauncher;
import com.exe4j.runtime.util.InternalErrorFrame;
import com.exe4j.runtime.util.LazyFileOutputStream;
import com.exe4j.runtime.util.NullOutputStream;
import com.exe4j.runtime.util.ResourceHelper;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public class LauncherEngine {
    private static Properties properties;
    public static final String DEV_NULL = "/dev/null";
    public static final String PROPNAME_MODULE_NAME = "exe4j.moduleName";
    public static final String PROPNAME_APP_DIR = "install4j.appDir";
    public static final String PROPNAME_EXE_DIR = "install4j.exeDir";
    public static final String PROPNAME_NO_REDIRECTION = "install4j.noRedir";
    public static final int EXE4J_MAGIC = -387705899;

    public static void launch(String className, String[] args, String stdErrFile, String stdOutFile, boolean failOnMainMethodException, boolean guiApplication, ClassLoader classLoader) {
        File runtimeDir;
        String moduleName;
        if (Boolean.getBoolean(PROPNAME_NO_REDIRECTION)) {
            stdErrFile = "";
            stdOutFile = "";
        }
        if ((moduleName = System.getProperty(PROPNAME_MODULE_NAME)) != null) {
            try {
                System.setProperty(PROPNAME_EXE_DIR, new File(moduleName).getParentFile().getCanonicalPath() + File.separator);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((!WinLauncher.isUsed() || WinLauncher.APP_MODE_INSTALL4J) && (runtimeDir = ResourceHelper.getRuntimeDir()) != null) {
            System.setProperty(PROPNAME_APP_DIR, runtimeDir.getParentFile().getAbsolutePath() + File.separator);
        }
        try {
            try {
                LauncherEngine.doRedirection(stdErrFile, stdOutFile);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                Class[] mainParamClasses = new Class[]{String[].class};
                Object[] mainParams = new Object[]{args};
                Class<?> mainClass = classLoader.loadClass(className);
                Method mainMethod = mainClass.getDeclaredMethod("main", mainParamClasses);
                mainMethod.setAccessible(true);
                mainMethod.invoke(null, mainParams);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                LauncherEngine.handleFailure(failOnMainMethodException, guiApplication, cause != null ? cause : e);
            }
            catch (Throwable t) {
                LauncherEngine.handleFailure(failOnMainMethodException, guiApplication, t);
            }
        }
        catch (Throwable t) {
            LauncherEngine.handleFailure(true, guiApplication, t);
        }
    }

    public static String getProperty(int key) {
        return properties.getProperty(String.valueOf(key));
    }

    public static boolean getBooleanProperty(int key) {
        try {
            return Integer.parseInt(LauncherEngine.getProperty(key)) == 1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int getIntProperty(int key) {
        try {
            return Integer.parseInt(LauncherEngine.getProperty(key));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private LauncherEngine() {
    }

    public static void setProperties(Properties properties) {
        LauncherEngine.properties = properties;
    }

    private static void handleFailure(boolean failOnMainMethodException, boolean guiApplication, final Throwable t) {
        if (t != null) {
            t.printStackTrace();
        }
        if (failOnMainMethodException) {
            if (guiApplication && !GraphicsEnvironment.isHeadless()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new InternalErrorFrame(t).setVisible(true);
                    }
                });
            } else {
                System.exit(1);
            }
        }
    }

    private static void doRedirection(String stdErrFile, String stdOutFile) throws FileNotFoundException {
        PrintStream out = null;
        if (stdOutFile.equals(DEV_NULL)) {
            System.setOut(new PrintStream(new NullOutputStream()));
        } else if (stdOutFile.length() > 0 && LauncherEngine.checkRedirectionFile(stdOutFile)) {
            out = new PrintStream(new BufferedOutputStream(new LazyFileOutputStream(stdOutFile)), true);
            System.setOut(out);
        }
        if (stdErrFile.equals(DEV_NULL)) {
            System.setErr(new PrintStream(new NullOutputStream()));
        } else if (stdErrFile.length() > 0 && LauncherEngine.checkRedirectionFile(stdErrFile)) {
            PrintStream err = stdErrFile.equalsIgnoreCase(stdOutFile) ? out : new PrintStream(new LazyFileOutputStream(stdErrFile), true);
            System.setErr(err);
        }
    }

    private static boolean checkRedirectionFile(String fileName) throws FileNotFoundException {
        File file = new File(fileName);
        File parentFile = file.getParentFile();
        parentFile.mkdirs();
        if (!parentFile.exists()) {
            throw new FileNotFoundException("log file directory '" + parentFile + "' doesn't exist.");
        }
        if (file.exists()) {
            return file.canWrite();
        }
        return parentFile.canWrite();
    }
}

