# - Find libnet
#
# -*- cmake -*-
#
# Find the libnet module
#
#  LIBNET_INCLUDE_DIR - where to find libnet.h, etc.
#  LIBNET_LIBRARIES   - List of libraries when using LibNet.
#  LIBNET_FOUND       - True if libnet found.

IF (LIBNET_INCLUDE_DIR)
  # Already in cache, be silent
  SET(LIBNET_FIND_QUIETLY TRUE)
ENDIF (LIBNET_INCLUDE_DIR)

FIND_PATH(LIBNET_INCLUDE_DIR libnet.h
  /usr/include
)

SET(LIBNET_NAMES net)
FIND_LIBRARY(LIBNET_LIBRARY
  NAMES ${LIBNET_NAMES}
  PATHS /usr/lib /usr/local/lib
  PATH_SUFFIXES libnet
)

ADD_DEFINITIONS(-DLIBNET_LIL_ENDIAN=1)

IF (LIBNET_INCLUDE_DIR AND LIBNET_LIBRARY)
  SET(LIBNET_FOUND TRUE)
  SET(LIBNET_LIBRARIES ${LIBNET_LIBRARY} )
  
ELSE (LIBNET_INCLUDE_DIR AND LIBNET_LIBRARY)
  SET(LIBNET_FOUND FALSE)
  SET(LIBNET_LIBRARIES )
ENDIF (LIBNET_INCLUDE_DIR AND LIBNET_LIBRARY)

IF (LIBNET_FOUND)
  IF (NOT LIBNET_FIND_QUIETLY)
    MESSAGE(STATUS "Found LibNet: ${LIBNET_LIBRARY}")
  ENDIF (NOT LIBNET_FIND_QUIETLY)
ELSE (LIBNET_FOUND)
  IF (LIBNET_FIND_REQUIRED)
    MESSAGE(STATUS "Looked for LibNet libraries named ${LIBNET_NAMES}.")
    MESSAGE(FATAL_ERROR "Could NOT find LibNet library")
  ENDIF (LIBNET_FIND_REQUIRED)
ENDIF (LIBNET_FOUND)

MARK_AS_ADVANCED(
  LIBNET_LIBRARY
  LIBNET_INCLUDE_DIR
  )