/*
 * Jitsi, the OpenSource Java VoIP and Instant Messaging client.
 *
 * Copyright @ 2015 Atlassian Pty Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.java.sip.communicator.service.gui;

/**
 * The <tt>ExtendedDesktopAccountRegWizard</tt> allows to specify if a sign up
 * form is supported for a desktop specific account registration.
 *
 * @author Yana Stamcheva
 */
public abstract class ExtendedDesktopAccountRegWizard
    extends DesktopAccountRegistrationWizard
{
    /**
     * Indicates if a sign up form is supported by this wizard.
     *
     * @return <tt>true</tt> if a sign up form is supported by this wizard,
     * <tt>false</tt> - otherwise
     */
    public abstract boolean isSignupSupported();

    /**
     * Sets the create account view of this registration wizard.
     */
    public abstract void setCreateAccountView();
}
