/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import net.sf.fmj.media.BasicController;
import net.sf.fmj.media.util.MediaThread;

abstract class TimedActionThread
extends MediaThread {
    protected BasicController controller;
    protected long wakeupTime;
    protected boolean aborted = false;

    TimedActionThread(BasicController mc, long nanoseconds) {
        this.controller = mc;
        this.useControlPriority();
        this.wakeupTime = nanoseconds;
    }

    public synchronized void abort() {
        this.aborted = true;
        this.notify();
    }

    protected abstract void action();

    protected abstract long getTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long now;
        while ((now = this.getTime()) < this.wakeupTime && !this.aborted) {
            long sleepTime = this.wakeupTime - now;
            if (sleepTime > 1000000000L) {
                sleepTime = 1000000000L;
            }
            TimedActionThread timedActionThread = this;
            synchronized (timedActionThread) {
                try {
                    this.wait(sleepTime / 1000000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        if (!this.aborted) {
            this.action();
        }
    }
}

