/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.components;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class UTF8ResourceBundle {
    public static final ResourceBundle getBundle(String string, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
        if (!(resourceBundle instanceof PropertyResourceBundle)) {
            return resourceBundle;
        }
        return new UTF8PropertyResourceBundle((PropertyResourceBundle)resourceBundle);
    }

    private static class UTF8PropertyResourceBundle
    extends ResourceBundle {
        PropertyResourceBundle propertyResourceBundle;

        private UTF8PropertyResourceBundle(PropertyResourceBundle propertyResourceBundle) {
            this.propertyResourceBundle = propertyResourceBundle;
        }

        public Enumeration getKeys() {
            return this.propertyResourceBundle.getKeys();
        }

        protected Object handleGetObject(String string) {
            String string2 = (String)this.propertyResourceBundle.handleGetObject(string);
            if (string2 != null) {
                try {
                    return new String(string2.getBytes("ISO-8859-1"), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException("UTF-8 encoding is not supported.", unsupportedEncodingException);
                }
            }
            return null;
        }
    }
}

