/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.discovery;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iot.IoTManager;
import org.jivesoftware.smackx.iot.Thing;
import org.jivesoftware.smackx.iot.control.IoTControlManager;
import org.jivesoftware.smackx.iot.data.IoTDataManager;
import org.jivesoftware.smackx.iot.discovery.IoTClaimedException;
import org.jivesoftware.smackx.iot.discovery.ThingState;
import org.jivesoftware.smackx.iot.discovery.element.IoTClaimed;
import org.jivesoftware.smackx.iot.discovery.element.IoTDisown;
import org.jivesoftware.smackx.iot.discovery.element.IoTDisowned;
import org.jivesoftware.smackx.iot.discovery.element.IoTMine;
import org.jivesoftware.smackx.iot.discovery.element.IoTRegister;
import org.jivesoftware.smackx.iot.discovery.element.IoTRemove;
import org.jivesoftware.smackx.iot.discovery.element.IoTRemoved;
import org.jivesoftware.smackx.iot.discovery.element.IoTUnregister;
import org.jivesoftware.smackx.iot.discovery.element.Tag;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jivesoftware.smackx.iot.provisioning.IoTProvisioningManager;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public final class IoTDiscoveryManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(IoTDiscoveryManager.class.getName());
    private static final Map<XMPPConnection, IoTDiscoveryManager> INSTANCES = new WeakHashMap<XMPPConnection, IoTDiscoveryManager>();
    private Jid preconfiguredRegistry;
    private final Set<Jid> usedRegistries = new HashSet<Jid>();
    private final Map<NodeInfo, ThingState> things = new HashMap<NodeInfo, ThingState>();

    public static synchronized IoTDiscoveryManager getInstanceFor(XMPPConnection connection) {
        IoTDiscoveryManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new IoTDiscoveryManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private IoTDiscoveryManager(XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("claimed", "urn:xmpp:iot:discovery", IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iqRequest) {
                if (!IoTDiscoveryManager.this.isRegistry(iqRequest.getFrom())) {
                    LOGGER.log(Level.SEVERE, "Received control stanza from non-registry entity: " + iqRequest);
                    return null;
                }
                IoTClaimed iotClaimed = (IoTClaimed)iqRequest;
                Jid owner = iotClaimed.getJid();
                NodeInfo nodeInfo = iotClaimed.getNodeInfo();
                ThingState state = IoTDiscoveryManager.this.getStateFor(nodeInfo);
                state.setOwner(owner.asBareJid());
                LOGGER.info("Our thing got claimed by " + owner + ". " + (Object)((Object)iotClaimed));
                IoTProvisioningManager iotProvisioningManager = IoTProvisioningManager.getInstanceFor(IoTDiscoveryManager.this.connection());
                try {
                    iotProvisioningManager.sendFriendshipRequest(owner.asBareJid());
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    LOGGER.log(Level.WARNING, "Could not friendship owner", e);
                }
                return IQ.createResultIQ((IQ)iqRequest);
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("disown", "urn:xmpp:iot:discovery", IQ.Type.set, IQRequestHandler.Mode.sync){

            public IQ handleIQRequest(IQ iqRequest) {
                NodeInfo nodeInfo;
                ThingState state;
                if (!IoTDiscoveryManager.this.isRegistry(iqRequest.getFrom())) {
                    LOGGER.log(Level.SEVERE, "Received control stanza from non-registry entity: " + iqRequest);
                    return null;
                }
                IoTDisowned iotDisowned = (IoTDisowned)iqRequest;
                Jid from = iqRequest.getFrom();
                if (!from.equals((CharSequence)(state = IoTDiscoveryManager.this.getStateFor(nodeInfo = iotDisowned.getNodeInfo())).getRegistry())) {
                    LOGGER.severe("Received <disowned/> for " + nodeInfo + " from " + from + " but this is not the registry " + state.getRegistry() + " of the thing.");
                    return null;
                }
                if (state.isOwned()) {
                    state.setUnowned();
                } else {
                    LOGGER.fine("Received <disowned/> for " + nodeInfo + " but thing was not owned.");
                }
                return IQ.createResultIQ((IQ)iqRequest);
            }
        });
        connection.registerIQRequestHandler((IQRequestHandler)new AbstractIqRequestHandler("removed", "urn:xmpp:iot:discovery", IQ.Type.set, IQRequestHandler.Mode.async){

            public IQ handleIQRequest(IQ iqRequest) {
                if (!IoTDiscoveryManager.this.isRegistry(iqRequest.getFrom())) {
                    LOGGER.log(Level.SEVERE, "Received control stanza from non-registry entity: " + iqRequest);
                    return null;
                }
                IoTRemoved iotRemoved = (IoTRemoved)iqRequest;
                ThingState state = IoTDiscoveryManager.this.getStateFor(iotRemoved.getNodeInfo());
                state.setRemoved();
                try {
                    IoTProvisioningManager.getInstanceFor(IoTDiscoveryManager.this.connection()).unfriend(iotRemoved.getFrom());
                }
                catch (InterruptedException | SmackException.NotConnectedException e) {
                    LOGGER.log(Level.SEVERE, "Could not unfriend registry after <removed/>", e);
                }
                return IQ.createResultIQ((IQ)iqRequest);
            }
        });
    }

    public Jid findRegistry() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.preconfiguredRegistry != null) {
            return this.preconfiguredRegistry;
        }
        XMPPConnection connection = this.connection();
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        List discoverInfos = sdm.findServicesDiscoverInfo("urn:xmpp:iot:discovery", true, true);
        if (!discoverInfos.isEmpty()) {
            return ((DiscoverInfo)discoverInfos.get(0)).getFrom();
        }
        return null;
    }

    public ThingState registerThing(Thing thing) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, IoTClaimedException {
        Jid registry = this.findRegistry();
        return this.registerThing(registry, thing);
    }

    public ThingState registerThing(Jid registry, Thing thing) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, IoTClaimedException {
        XMPPConnection connection = this.connection();
        IoTRegister iotRegister = new IoTRegister(thing.getMetaTags(), thing.getNodeInfo(), thing.isSelfOwened());
        iotRegister.setTo(registry);
        IQ result = (IQ)connection.createStanzaCollectorAndSend((IQ)iotRegister).nextResultOrThrow();
        if (result instanceof IoTClaimed) {
            IoTClaimed iotClaimedResult = (IoTClaimed)result;
            throw new IoTClaimedException(iotClaimedResult);
        }
        ThingState state = this.getStateFor(thing.getNodeInfo());
        state.setRegistry(registry.asBareJid());
        this.interactWithRegistry(registry);
        IoTDataManager.getInstanceFor(connection).installThing(thing);
        IoTControlManager.getInstanceFor(connection).installThing(thing);
        return state;
    }

    public IoTClaimed claimThing(Collection<Tag> metaTags) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.claimThing(metaTags, true);
    }

    public IoTClaimed claimThing(Collection<Tag> metaTags, boolean publicThing) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid registry = this.findRegistry();
        return this.claimThing(registry, metaTags, publicThing);
    }

    public IoTClaimed claimThing(Jid registry, Collection<Tag> metaTags, boolean publicThing) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.interactWithRegistry(registry);
        IoTMine iotMine = new IoTMine(metaTags, publicThing);
        iotMine.setTo(registry);
        IoTClaimed iotClaimed = (IoTClaimed)this.connection().createStanzaCollectorAndSend((IQ)iotMine).nextResultOrThrow();
        Jid thing = iotClaimed.getJid();
        IoTProvisioningManager.getInstanceFor(this.connection()).sendFriendshipRequest(thing.asBareJid());
        return iotClaimed;
    }

    public void removeThing(BareJid thing) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.removeThing(thing, NodeInfo.EMPTY);
    }

    public void removeThing(BareJid thing, NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid registry = this.findRegistry();
        this.removeThing(registry, thing, nodeInfo);
    }

    public void removeThing(Jid registry, BareJid thing, NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.interactWithRegistry(registry);
        IoTRemove iotRemove = new IoTRemove(thing, nodeInfo);
        iotRemove.setTo(registry);
        this.connection().createStanzaCollectorAndSend((IQ)iotRemove).nextResultOrThrow();
    }

    public void unregister() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.unregister(NodeInfo.EMPTY);
    }

    public void unregister(NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid registry = this.findRegistry();
        this.unregister(registry, nodeInfo);
    }

    public void unregister(Jid registry, NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.interactWithRegistry(registry);
        IoTUnregister iotUnregister = new IoTUnregister(nodeInfo);
        iotUnregister.setTo(registry);
        this.connection().createStanzaCollectorAndSend((IQ)iotUnregister).nextResultOrThrow();
        ThingState state = this.getStateFor(nodeInfo);
        state.setUnregistered();
        XMPPConnection connection = this.connection();
        IoTDataManager.getInstanceFor(connection).uninstallThing(nodeInfo);
        IoTControlManager.getInstanceFor(connection).uninstallThing(nodeInfo);
    }

    public void disownThing(Jid thing) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.disownThing(thing, NodeInfo.EMPTY);
    }

    public void disownThing(Jid thing, NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Jid registry = this.findRegistry();
        this.disownThing(registry, thing, nodeInfo);
    }

    public void disownThing(Jid registry, Jid thing, NodeInfo nodeInfo) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.interactWithRegistry(registry);
        IoTDisown iotDisown = new IoTDisown(thing, nodeInfo);
        iotDisown.setTo(registry);
        this.connection().createStanzaCollectorAndSend((IQ)iotDisown).nextResultOrThrow();
    }

    public boolean isRegistry(BareJid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Objects.requireNonNull((Object)jid, (String)"JID argument must not be null");
        Jid registry = this.findRegistry();
        if (jid.equals((CharSequence)registry)) {
            return true;
        }
        return this.usedRegistries.contains(jid);
    }

    public boolean isRegistry(Jid jid) {
        try {
            return this.isRegistry(jid.asBareJid());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            LOGGER.log(Level.WARNING, "Could not determine if " + jid + " is a registry", e);
            return false;
        }
    }

    private void interactWithRegistry(Jid registry) throws SmackException.NotConnectedException, InterruptedException {
        boolean isNew = this.usedRegistries.add(registry);
        if (!isNew) {
            return;
        }
        IoTProvisioningManager iotProvisioningManager = IoTProvisioningManager.getInstanceFor(this.connection());
        iotProvisioningManager.sendFriendshipRequestIfRequired(registry.asBareJid());
    }

    public ThingState getStateFor(Thing thing) {
        return this.things.get(thing.getNodeInfo());
    }

    private ThingState getStateFor(NodeInfo nodeInfo) {
        ThingState state = this.things.get(nodeInfo);
        if (state == null) {
            state = new ThingState(nodeInfo);
            this.things.put(nodeInfo, state);
        }
        return state;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                if (!IoTManager.isAutoEnableActive()) {
                    return;
                }
                IoTDiscoveryManager.getInstanceFor(connection);
            }
        });
    }
}

