/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util.function;

import java.util.function.Function;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.function.SeqNumTranslation;
import org.jitsi.utils.ByteArrayBuffer;

public class SeqNumPacketTranslation<T extends ByteArrayBuffer>
implements Function<T, T> {
    private final SeqNumTranslation seqNumTranslation;

    public SeqNumPacketTranslation(int seqNumDelta) {
        this.seqNumTranslation = new SeqNumTranslation(seqNumDelta);
    }

    @Override
    public ByteArrayBuffer apply(ByteArrayBuffer baf) {
        int dstSeqNum;
        int srcSeqNum;
        if (RTPPacketPredicate.INSTANCE.test(baf) && (srcSeqNum = RawPacket.getSequenceNumber(baf)) != (dstSeqNum = this.seqNumTranslation.apply(srcSeqNum).intValue())) {
            RawPacket.setSequenceNumber(baf, dstSeqNum);
        }
        return baf;
    }
}

