/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import java.util.HashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.rtp.ResumableStreamRewriter;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.util.RTCPUtils;
import org.jitsi.utils.logging.Logger;

public class DiscardTransformEngine
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(DiscardTransformEngine.class);
    private final Map<Long, ResumableStreamRewriter> ssrcToRewriter = new HashMap<Long, ResumableStreamRewriter>();
    private final MediaStream stream;
    private final PacketTransformer rtpTransformer = new SinglePacketTransformerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            ResumableStreamRewriter rewriter;
            if (pkt == null) {
                return null;
            }
            boolean dropPkt = (pkt.getFlags() & 2) == 2;
            long ssrc = pkt.getSSRCAsLong();
            Map map = DiscardTransformEngine.this.ssrcToRewriter;
            synchronized (map) {
                rewriter = (ResumableStreamRewriter)DiscardTransformEngine.this.ssrcToRewriter.get(ssrc);
                if (rewriter == null) {
                    rewriter = new ResumableStreamRewriter();
                    DiscardTransformEngine.this.ssrcToRewriter.put(ssrc, rewriter);
                }
            }
            rewriter.rewriteRTP(!dropPkt, pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)((dropPkt ? "discarding " : "passing through ") + " RTP ssrc=" + pkt.getSSRCAsLong() + ", seqnum=" + pkt.getSequenceNumber() + ", ts=" + pkt.getTimestamp() + ", streamHashCode=" + DiscardTransformEngine.this.stream.hashCode()));
            }
            return dropPkt ? null : pkt;
        }
    };
    private final PacketTransformer rtcpTransformer = new SinglePacketTransformerAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            int length;
            int offset;
            if (pkt == null) {
                return pkt;
            }
            byte[] buf = pkt.getBuffer();
            if (!RawPacket.isRtpRtcp(buf, offset = pkt.getOffset(), length = pkt.getLength())) {
                return pkt;
            }
            int pktLen = RTCPUtils.getLength(buf, offset, length);
            int pt = RTCPUtils.getPacketType(buf, offset, pktLen);
            if (pt == 200) {
                ResumableStreamRewriter rewriter;
                long ssrc = RawPacket.getRTCPSSRC(buf, offset, pktLen);
                Map map = DiscardTransformEngine.this.ssrcToRewriter;
                synchronized (map) {
                    rewriter = (ResumableStreamRewriter)DiscardTransformEngine.this.ssrcToRewriter.get(ssrc);
                }
                if (rewriter != null) {
                    rewriter.processRTCP(true, buf, offset, pktLen);
                }
            }
            return pkt;
        }
    };

    public DiscardTransformEngine(MediaStream stream) {
        this.stream = stream;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.rtpTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }
}

