/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets.plaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScrollBarOrientation {
    HORIZONTAL{

        int getThickness(Dimension size) {
            return size.height;
        }

        int getLength(Dimension size) {
            return size.width;
        }

        int getPosition(Point point) {
            return point.x;
        }

        Rectangle updateBoundsPosition(Rectangle bounds, int newPosition) {
            bounds.setLocation(newPosition, bounds.y);
            return bounds;
        }

        Rectangle createBounds(Component container, int position, int length) {
            return new Rectangle(position, 0, length, container.getHeight());
        }

        Rectangle createCenteredBounds(Component container, int position, int thickness, int length) {
            int y = container.getHeight() / 2 - thickness / 2;
            return new Rectangle(position, y, length, thickness);
        }
    }
    ,
    VERTICAL{

        int getThickness(Dimension size) {
            return size.width;
        }

        int getLength(Dimension size) {
            return size.height;
        }

        int getPosition(Point point) {
            return point.y;
        }

        Rectangle updateBoundsPosition(Rectangle bounds, int newPosition) {
            bounds.setLocation(bounds.x, newPosition);
            return bounds;
        }

        Rectangle createBounds(Component container, int position, int length) {
            return new Rectangle(0, position, container.getWidth(), length);
        }

        Rectangle createCenteredBounds(Component container, int position, int thickness, int length) {
            int x = container.getWidth() / 2 - thickness / 2;
            return new Rectangle(x, position, thickness, length);
        }
    };


    public static ScrollBarOrientation getOrientation(int swingScrollBarOrientation) {
        if (swingScrollBarOrientation != 0 && swingScrollBarOrientation != 1) {
            throw new IllegalArgumentException("The given value is not a valid scroll bar orientation.");
        }
        return swingScrollBarOrientation == 0 ? HORIZONTAL : VERTICAL;
    }

    abstract int getThickness(Dimension var1);

    abstract int getLength(Dimension var1);

    abstract int getPosition(Point var1);

    abstract Rectangle updateBoundsPosition(Rectangle var1, int var2);

    abstract Rectangle createBounds(Component var1, int var2, int var3);

    abstract Rectangle createCenteredBounds(Component var1, int var2, int var3, int var4);
}

