/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Reminder
extends ExtensionPoint
implements Extension {
    protected Integer days;
    protected Integer hours;
    protected Integer minutes;
    protected DateTime absoluteTime;
    protected Method method;

    public Integer getDays() {
        return this.days;
    }

    public void setDays(Integer v) {
        this.days = v;
    }

    public Integer getHours() {
        return this.hours;
    }

    public void setHours(Integer v) {
        this.hours = v;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public void setMinutes(Integer v) {
        this.minutes = v;
    }

    public DateTime getAbsoluteTime() {
        return this.absoluteTime;
    }

    public void setAbsoluteTime(DateTime v) {
        this.absoluteTime = v;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method v) {
        this.method = v;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Reminder.class);
        desc.setNamespace(Namespaces.gNs);
        desc.setLocalName("reminder");
        desc.setRepeatable(true);
        return desc;
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.days != null) {
            attrs.add(new XmlWriter.Attribute("days", this.days.toString()));
        }
        if (this.hours != null) {
            attrs.add(new XmlWriter.Attribute("hours", this.hours.toString()));
        }
        if (this.minutes != null) {
            attrs.add(new XmlWriter.Attribute("minutes", this.minutes.toString()));
        }
        if (this.absoluteTime != null) {
            attrs.add(new XmlWriter.Attribute("absoluteTime", this.absoluteTime.toString()));
        }
        if (this.method != null) {
            attrs.add(new XmlWriter.Attribute("method", this.method.generate()));
        }
        this.generateStartElement(w, Namespaces.gNs, "reminder", attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "reminder");
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(Reminder.this, extProfile, Reminder.class);
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("days")) {
                    try {
                        Reminder.this.days = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidReminderDays, (Throwable)e);
                    }
                }
                if (localName.equals("hours")) {
                    try {
                        Reminder.this.hours = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidReminderHours, (Throwable)e);
                    }
                }
                if (localName.equals("minutes")) {
                    try {
                        Reminder.this.minutes = Integer.valueOf(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidReminderMinutes, (Throwable)e);
                    }
                }
                if (localName.equals("absoluteTime")) {
                    try {
                        Reminder.this.absoluteTime = DateTime.parseDateTime(value);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidReminderAbsoluteTime, (Throwable)e);
                    }
                }
                if (localName.equals("method")) {
                    try {
                        Reminder.this.method = Method.fromString(value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidReminderMethod, (Throwable)e);
                    }
                }
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if ((Reminder.this.days == null ? 0 : 1) + (Reminder.this.hours == null ? 0 : 1) + (Reminder.this.minutes == null ? 0 : 1) + (Reminder.this.absoluteTime == null ? 0 : 1) > 1) {
                throw new ParseException(CoreErrorDomain.ERR.tooManyAttributes);
            }
            super.processEndElement();
        }
    }

    public static enum Method {
        ALERT,
        ALL,
        EMAIL,
        NONE,
        SMS;


        public static Method fromString(String s) {
            if (!s.equals(s.toLowerCase())) {
                throw new IllegalArgumentException("Bad input for method: " + s);
            }
            return Enum.valueOf(Method.class, s.toUpperCase());
        }

        public String generate() {
            return this.name().toLowerCase();
        }
    }
}

