/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="im")
public class Im
extends ExtensionPoint {
    static final String XML_NAME = "im";
    private static final String ADDRESS = "address";
    private static final String LABEL = "label";
    private static final String PRIMARY = "primary";
    private static final String PROTOCOL = "protocol";
    private static final String REL = "rel";
    private String address = null;
    private String label = null;
    private Boolean primary = null;
    private String protocol = null;
    private String rel = null;

    public Im() {
    }

    public Im(String address, String label, Boolean primary, String protocol, String rel) {
        this.setAddress(address);
        this.setLabel(label);
        this.setPrimary(primary);
        this.setProtocol(protocol);
        this.setRel(rel);
        this.setImmutable(true);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.throwExceptionIfImmutable();
        this.address = address;
    }

    public boolean hasAddress() {
        return this.getAddress() != null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.throwExceptionIfImmutable();
        this.label = label;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.throwExceptionIfImmutable();
        this.primary = primary;
    }

    public boolean hasPrimary() {
        return this.getPrimary() != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.throwExceptionIfImmutable();
        this.protocol = protocol;
    }

    public boolean hasProtocol() {
        return this.getProtocol() != null;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.throwExceptionIfImmutable();
        this.rel = rel;
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    @Override
    protected void validate() {
        if (this.address == null) {
            Im.throwExceptionForMissingAttribute(ADDRESS);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Im.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(ADDRESS, this.address);
        generator.put(LABEL, this.label);
        generator.put(PRIMARY, this.primary);
        generator.put(PROTOCOL, this.protocol);
        generator.put(REL, this.rel);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.address = helper.consume(ADDRESS, true);
        this.label = helper.consume(LABEL, false);
        this.primary = helper.consumeBoolean(PRIMARY, false);
        this.protocol = helper.consume(PROTOCOL, false);
        this.rel = helper.consume(REL, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Im other = (Im)obj;
        return Im.eq(this.address, other.address) && Im.eq(this.label, other.label) && Im.eq(this.primary, other.primary) && Im.eq(this.protocol, other.protocol) && Im.eq(this.rel, other.rel);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.address != null) {
            result = 37 * result + this.address.hashCode();
        }
        if (this.label != null) {
            result = 37 * result + this.label.hashCode();
        }
        if (this.primary != null) {
            result = 37 * result + this.primary.hashCode();
        }
        if (this.protocol != null) {
            result = 37 * result + this.protocol.hashCode();
        }
        if (this.rel != null) {
            result = 37 * result + this.rel.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Im address=" + this.address + " label=" + this.label + " primary=" + this.primary + " protocol=" + this.protocol + " rel=" + this.rel + "}";
    }

    public static final class Rel {
        public static final String HOME = "http://schemas.google.com/g/2005#home";
        public static final String OTHER = "http://schemas.google.com/g/2005#other";
        public static final String WORK = "http://schemas.google.com/g/2005#work";
    }

    public static final class Protocol {
        public static final String AIM = "http://schemas.google.com/g/2005#AIM";
        public static final String GOOGLE_TALK = "http://schemas.google.com/g/2005#GOOGLE_TALK";
        public static final String ICQ = "http://schemas.google.com/g/2005#ICQ";
        public static final String JABBER = "http://schemas.google.com/g/2005#JABBER";
        public static final String MSN = "http://schemas.google.com/g/2005#MSN";
        public static final String NETMEETING = "http://schemas.google.com/g/2005#NETMEETING";
        public static final String QQ = "http://schemas.google.com/g/2005#QQ";
        public static final String SKYPE = "http://schemas.google.com/g/2005#SKYPE";
        public static final String YAHOO = "http://schemas.google.com/g/2005#YAHOO";
    }
}

