/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="fullName")
public class FullName
extends AbstractExtension {
    static final String XML_NAME = "fullName";
    private static final String YOMI = "yomi";
    private String value = null;
    private String yomi = null;

    public FullName() {
    }

    public FullName(String value, String yomi) {
        this.setValue(value);
        this.setYomi(yomi);
        this.setImmutable(true);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    public String getYomi() {
        return this.yomi;
    }

    public void setYomi(String yomi) {
        this.throwExceptionIfImmutable();
        this.yomi = yomi;
    }

    public boolean hasYomi() {
        return this.getYomi() != null;
    }

    @Override
    protected void validate() {
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(FullName.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.setContent(this.value);
        generator.put(YOMI, this.yomi);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.value = helper.consume(null, true);
        this.yomi = helper.consume(YOMI, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        FullName other = (FullName)obj;
        return FullName.eq(this.value, other.value) && FullName.eq(this.yomi, other.yomi);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        if (this.yomi != null) {
            result = 37 * result + this.yomi.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{FullName value=" + this.value + " yomi=" + this.yomi + "}";
    }
}

