/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Email
extends ExtensionPoint
implements Extension {
    protected String rel;
    protected String label;
    protected String address;
    protected String quota;
    protected boolean primary;
    protected String displayName;

    public String getRel() {
        return this.rel;
    }

    public void setRel(String v) {
        this.rel = v;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String v) {
        this.label = v;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String v) {
        this.address = v;
    }

    public String getQuota() {
        return this.quota;
    }

    public void setQuota(String v) {
        this.quota = v;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean p) {
        this.primary = p;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String n) {
        this.displayName = n;
    }

    public static ExtensionDescription getDefaultDescription() {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(Email.class);
        desc.setNamespace(Namespaces.gNs);
        desc.setLocalName("email");
        desc.setRepeatable(true);
        return desc;
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.rel != null) {
            attrs.add(new XmlWriter.Attribute("rel", this.rel));
        }
        if (this.label != null) {
            attrs.add(new XmlWriter.Attribute("label", this.label));
        }
        if (this.address != null) {
            attrs.add(new XmlWriter.Attribute("address", this.address));
        }
        if (this.quota != null) {
            attrs.add(new XmlWriter.Attribute("quota", this.quota));
        }
        if (this.primary) {
            attrs.add(new XmlWriter.Attribute("primary", true));
        }
        if (this.displayName != null) {
            attrs.add(new XmlWriter.Attribute("displayName", this.displayName));
        }
        this.generateStartElement(w, Namespaces.gNs, "email", attrs, null);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.gNs, "email");
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) {
        return new Handler(extProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile) {
            super(Email.this, extProfile, Email.class);
        }

        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("rel")) {
                    Email.this.rel = value;
                } else if (localName.equals("label")) {
                    Email.this.label = value;
                } else if (localName.equals("address")) {
                    Email.this.address = value;
                } else if (localName.equals("quota")) {
                    Email.this.quota = value;
                } else if (localName.equals("primary")) {
                    Boolean pr = this.parseBooleanValue(value);
                    Email.this.primary = pr != null ? pr : false;
                } else if (localName.equals("displayName")) {
                    Email.this.displayName = value;
                }
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if (Email.this.address == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingAddressAttribute);
            }
            super.processEndElement();
        }
    }

    public static final class Rel {
        public static final String GENERAL = null;
        public static final String HOME = "http://schemas.google.com/g/2005#home";
        public static final String WORK = "http://schemas.google.com/g/2005#work";
        public static final String OTHER = "http://schemas.google.com/g/2005#other";
    }
}

