/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AbstractAimSession;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AppSession;
import net.kano.joustsim.oscar.DefaultAppSession;
import net.kano.joustsim.trust.TrustPreferences;

public class DefaultAimSession
extends AbstractAimSession {
    private final AppSession appSession;
    private final Screenname screenname;
    private final TrustPreferences trustPreferences;
    private AimConnection connection = null;

    public DefaultAimSession(Screenname screenname) {
        this(new DefaultAppSession(), screenname);
    }

    public DefaultAimSession(AppSession appSession, Screenname screenname) {
        this(appSession, screenname, null);
    }

    public DefaultAimSession(AppSession appSession, Screenname screenname, TrustPreferences trustPreferences) {
        this.appSession = appSession;
        this.screenname = screenname;
        this.trustPreferences = trustPreferences;
    }

    public AppSession getAppSession() {
        return this.appSession;
    }

    public Screenname getScreenname() {
        return this.screenname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AimConnection openConnection(AimConnectionProperties props) {
        this.closeConnection();
        AimConnection conn = new AimConnection(this, this.getTrustPreferences(), props);
        DefaultAimSession defaultAimSession = this;
        synchronized (defaultAimSession) {
            this.connection = conn;
        }
        this.fireOpenedConnection(conn);
        return conn;
    }

    public synchronized AimConnection getConnection() {
        return this.connection;
    }

    public void closeConnection() {
        AimConnection conn = this.getConnection();
        if (conn != null) {
            conn.disconnect();
        }
    }

    public TrustPreferences getTrustPreferences() {
        return this.trustPreferences;
    }
}

