/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import socks.InetRange;
import socks.ProxyMessage;
import socks.server.Ident;
import socks.server.ServerAuthenticator;
import socks.server.ServerAuthenticatorNone;

public class IdentAuthenticator
extends ServerAuthenticatorNone {
    Vector hosts;
    Vector users;
    String user;

    public IdentAuthenticator() {
        this.hosts = new Vector();
        this.users = new Vector();
    }

    IdentAuthenticator(InputStream in, OutputStream out, String user) {
        super(in, out);
        this.user = user;
    }

    public synchronized void add(InetRange hostRange, Hashtable users) {
        this.hosts.addElement(hostRange);
        this.users.addElement(users);
    }

    public ServerAuthenticator startSession(Socket s) throws IOException {
        int ind = this.getRangeIndex(s.getInetAddress());
        String user = null;
        if (ind < 0) {
            return null;
        }
        ServerAuthenticatorNone auth = (ServerAuthenticatorNone)super.startSession(s);
        if (auth == null) {
            return null;
        }
        Hashtable user_names = (Hashtable)this.users.elementAt(ind);
        if (user_names != null) {
            Ident ident = new Ident(s);
            if (!ident.successful) {
                return null;
            }
            if (!user_names.containsKey(ident.userName)) {
                return null;
            }
            user = ident.userName;
        }
        return new IdentAuthenticator(auth.in, auth.out, user);
    }

    public boolean checkRequest(ProxyMessage msg, Socket s) {
        if (msg.version == 5 || this.user == null) {
            return true;
        }
        if (msg.version != 4) {
            return false;
        }
        return this.user.equals(msg.user);
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.hosts.size(); ++i) {
            s = s + "Range:" + this.hosts.elementAt(i) + "\nUsers:" + this.userNames(i) + "\n";
        }
        return s;
    }

    private int getRangeIndex(InetAddress ip) {
        int index = 0;
        Enumeration enm = this.hosts.elements();
        while (enm.hasMoreElements()) {
            InetRange ir = (InetRange)enm.nextElement();
            if (ir.contains(ip)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private String userNames(int i) {
        if (this.users.elementAt(i) == null) {
            return "Everybody is permitted.";
        }
        Enumeration enm = ((Hashtable)this.users.elementAt(i)).keys();
        if (!enm.hasMoreElements()) {
            return "";
        }
        String s = enm.nextElement().toString();
        while (enm.hasMoreElements()) {
            s = s + "; " + enm.nextElement();
        }
        return s;
    }
}

