/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jitsimeet;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Domainpart;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.xmlpull.v1.XmlPullParser;

public class ConferenceIqProvider
extends IQProvider<ConferenceIq> {
    public ConferenceIqProvider() {
        ProviderManager.addIQProvider((String)"conference", (String)"http://jitsi.org/protocol/focus", (Object)((Object)this));
    }

    public ConferenceIq parse(XmlPullParser parser, int initialDepth) throws Exception {
        ConferenceIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/focus".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("conference".equals(rootElement)) {
            String identity;
            String machineUID;
            String sessionId;
            String focusJid;
            iq = new ConferenceIq();
            EntityBareJid room = this.getRoomJid(parser.getAttributeValue("", "room"));
            iq.setRoom(room);
            String ready = parser.getAttributeValue("", "ready");
            if (StringUtils.isNotEmpty((CharSequence)ready)) {
                iq.setReady(Boolean.valueOf(ready));
            }
            if (StringUtils.isNotEmpty((CharSequence)(focusJid = parser.getAttributeValue("", "focusjid")))) {
                iq.setFocusJid(focusJid);
            }
            if (StringUtils.isNotEmpty((CharSequence)(sessionId = parser.getAttributeValue("", "session-id")))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(machineUID = parser.getAttributeValue("", "machine-uid")))) {
                iq.setMachineUID(machineUID);
            }
            if (StringUtils.isNotEmpty((CharSequence)(identity = parser.getAttributeValue("", "identity")))) {
                iq.setIdentity(identity);
            }
        } else {
            return null;
        }
        ConferenceIq.Property property = null;
        boolean done = false;
        while (!done) {
            switch (parser.next()) {
                case 3: {
                    String name = parser.getName();
                    if (rootElement.equals(name)) {
                        done = true;
                        break;
                    }
                    if (!"property".equals(name) || property == null) break;
                    iq.addProperty(property);
                    property = null;
                    break;
                }
                case 2: {
                    String propValue;
                    String name = parser.getName();
                    if (!"property".equals(name)) break;
                    property = new ConferenceIq.Property();
                    String propName = parser.getAttributeValue("", "name");
                    if (StringUtils.isNotEmpty((CharSequence)propName)) {
                        property.setName(propName);
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)(propValue = parser.getAttributeValue("", "value")))) break;
                    property.setValue(propValue);
                }
            }
        }
        return iq;
    }

    private EntityBareJid getRoomJid(String unescapedValue) throws XmppStringprepException {
        int ix = unescapedValue.lastIndexOf("@");
        if (ix == -1) {
            throw new XmppStringprepException(unescapedValue, "wrong room name jid format");
        }
        String domainPart = unescapedValue.substring(ix + 1);
        String localPart = unescapedValue.substring(0, ix);
        return JidCreate.entityBareFrom((Localpart)Localpart.from((String)localPart), (Domainpart)Domainpart.from((String)domainPart));
    }
}

