/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.jibri;

import org.apache.commons.lang3.StringUtils;
import org.jitsi.xmpp.extensions.jibri.JibriIq;
import org.jivesoftware.smack.provider.IQProvider;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.xmlpull.v1.XmlPullParser;

public class JibriIqProvider
extends IQProvider<JibriIq> {
    public JibriIq parse(XmlPullParser parser, int depth) throws Exception {
        JibriIq iq;
        String namespace = parser.getNamespace();
        if (!"http://jitsi.org/protocol/jibri".equals(namespace)) {
            return null;
        }
        String rootElement = parser.getName();
        if ("jibri".equals(rootElement)) {
            String sipAddress;
            String displayName;
            String failureStr;
            String appData;
            String sessionId;
            String youTubeBroadcastId;
            String streamId;
            String room;
            iq = new JibriIq();
            String action = parser.getAttributeValue("", "action");
            iq.setAction(JibriIq.Action.parse(action));
            String status = parser.getAttributeValue("", "status");
            iq.setStatus(JibriIq.Status.parse(status));
            String recordingMode = parser.getAttributeValue("", "recording_mode");
            if (StringUtils.isNotEmpty((CharSequence)recordingMode)) {
                iq.setRecordingMode(JibriIq.RecordingMode.parse(recordingMode));
            }
            if (StringUtils.isNotEmpty((CharSequence)(room = parser.getAttributeValue("", "room")))) {
                EntityBareJid roomJid = JidCreate.entityBareFrom((String)room);
                iq.setRoom(roomJid);
            }
            if (StringUtils.isNotEmpty((CharSequence)(streamId = parser.getAttributeValue("", "streamid")))) {
                iq.setStreamId(streamId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(youTubeBroadcastId = parser.getAttributeValue("", "you_tube_broadcast_id")))) {
                iq.setYouTubeBroadcastId(youTubeBroadcastId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(sessionId = parser.getAttributeValue("", "session_id")))) {
                iq.setSessionId(sessionId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(appData = parser.getAttributeValue("", "app_data")))) {
                iq.setAppData(appData);
            }
            if (StringUtils.isNotEmpty((CharSequence)(failureStr = parser.getAttributeValue("", "failure_reason")))) {
                iq.setFailureReason(JibriIq.FailureReason.parse(failureStr));
            }
            if (StringUtils.isNotEmpty((CharSequence)(displayName = parser.getAttributeValue("", "displayname")))) {
                iq.setDisplayName(displayName);
            }
            if (StringUtils.isNotEmpty((CharSequence)(sipAddress = parser.getAttributeValue("", "sipaddress")))) {
                iq.setSipAddress(sipAddress);
            }
        } else {
            return null;
        }
        return iq;
    }
}

