/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class XHTMLExtension
implements ExtensionElement {
    public static final String ELEMENT = "html";
    public static final String NAMESPACE = "http://jabber.org/protocol/xhtml-im";
    private final List<CharSequence> bodies = new ArrayList<CharSequence>();

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
        xml.rightAngleBracket();
        for (CharSequence body : this.getBodies()) {
            xml.append(body);
        }
        xml.closeElement((NamedElement)this);
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CharSequence> getBodies() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<CharSequence>(this.bodies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBody(CharSequence body) {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            this.bodies.add(body);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBodiesCount() {
        List<CharSequence> list = this.bodies;
        synchronized (list) {
            return this.bodies.size();
        }
    }

    public static XHTMLExtension from(Message message) {
        return (XHTMLExtension)message.getExtension(ELEMENT, NAMESPACE);
    }
}

