/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.batch;

import com.google.gdata.util.Namespaces;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum BatchOperationType {
    QUERY("query", "GET"),
    INSERT("insert", "POST"),
    UPDATE("update", "PUT"),
    DELETE("delete", "DELETE");

    private static final Map<String, BatchOperationType> BY_NAME;
    private final String name;
    private final String method;

    private BatchOperationType(String name, String method) {
        this.name = name;
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public String toString() {
        return this.name;
    }

    public static BatchOperationType forName(String name) {
        return BY_NAME.get(name);
    }

    public void generateAtom(XmlWriter w) throws IOException {
        List<XmlWriter.Attribute> attrs = Collections.singletonList(new XmlWriter.Attribute("type", this.getName()));
        w.simpleElement(Namespaces.batchNs, "operation", attrs, null);
    }

    static {
        BY_NAME = new HashMap<String, BatchOperationType>();
        for (BatchOperationType op : BatchOperationType.values()) {
            BY_NAME.put(op.getName(), op);
        }
    }
}

