/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.text.MessageFormat;
import org.freedesktop.dbus.Gettext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UInt32
extends Number
implements Comparable<UInt32> {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;
    private long value;

    public UInt32(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), l, 0L, 0xFFFFFFFFL));
        }
        this.value = l;
    }

    public UInt32(String string) {
        this(Long.parseLong(string));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public boolean equals(Object object) {
        return object instanceof UInt32 && ((UInt32)object).value == this.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public int compareTo(UInt32 uInt32) {
        return (int)(this.value - uInt32.value);
    }

    public String toString() {
        return "" + this.value;
    }
}

