/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import cx.ath.matthew.unix.UnixServerSocket;
import cx.ath.matthew.unix.UnixSocket;
import cx.ath.matthew.unix.UnixSocketAddress;
import cx.ath.matthew.utils.Hexdump;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.text.ParseException;
import java.util.Random;
import java.util.Vector;
import org.freedesktop.dbus.BusAddress;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Message;
import org.freedesktop.dbus.MessageReader;
import org.freedesktop.dbus.MessageWriter;

public class Transport {
    public MessageReader min;
    public MessageWriter mout;

    public Transport() {
    }

    public static String genGUID() {
        Random random = new Random();
        byte[] byArray = new byte[16];
        random.nextBytes(byArray);
        String string = Hexdump.toHex((byte[])byArray);
        return string.replaceAll(" ", "");
    }

    public Transport(BusAddress busAddress) throws IOException {
        this.connect(busAddress);
    }

    public Transport(String string) throws IOException, ParseException {
        this.connect(new BusAddress(string));
    }

    public Transport(String string, int n) throws IOException, ParseException {
        this.connect(new BusAddress(string), n);
    }

    public void connect(String string) throws IOException, ParseException {
        this.connect(new BusAddress(string), 0);
    }

    public void connect(String string, int n) throws IOException, ParseException {
        this.connect(new BusAddress(string), n);
    }

    public void connect(BusAddress busAddress) throws IOException {
        this.connect(busAddress, 0);
    }

    public void connect(BusAddress busAddress, int n) throws IOException {
        OutputStream outputStream = null;
        InputStream inputStream = null;
        UnixSocket unixSocket = null;
        Socket socket = null;
        int n2 = 0;
        int n3 = 0;
        if ("unix".equals(busAddress.getType())) {
            n3 = 1;
            if (null != busAddress.getParameter("listen")) {
                n2 = 1;
                UnixServerSocket unixServerSocket = new UnixServerSocket();
                if (null != busAddress.getParameter("abstract")) {
                    unixServerSocket.bind(new UnixSocketAddress(busAddress.getParameter("abstract"), true));
                } else if (null != busAddress.getParameter("path")) {
                    unixServerSocket.bind(new UnixSocketAddress(busAddress.getParameter("path"), false));
                }
                unixSocket = unixServerSocket.accept();
            } else {
                n2 = 2;
                unixSocket = new UnixSocket();
                if (null != busAddress.getParameter("abstract")) {
                    unixSocket.connect(new UnixSocketAddress(busAddress.getParameter("abstract"), true));
                } else if (null != busAddress.getParameter("path")) {
                    unixSocket.connect(new UnixSocketAddress(busAddress.getParameter("path"), false));
                }
            }
            unixSocket.setPassCred(true);
            inputStream = unixSocket.getInputStream();
            outputStream = unixSocket.getOutputStream();
        } else if ("tcp".equals(busAddress.getType())) {
            n3 = 2;
            if (null != busAddress.getParameter("listen")) {
                n2 = 1;
                ServerSocket serverSocket = new ServerSocket();
                serverSocket.bind(new InetSocketAddress(busAddress.getParameter("host"), Integer.parseInt(busAddress.getParameter("port"))));
                socket = serverSocket.accept();
            } else {
                n2 = 2;
                socket = new Socket();
                socket.connect(new InetSocketAddress(busAddress.getParameter("host"), Integer.parseInt(busAddress.getParameter("port"))));
            }
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
        } else {
            throw new IOException(Gettext._("unknown address type ") + busAddress.getType());
        }
        if (!new SASL().auth(n2, n3, busAddress.getParameter("guid"), outputStream, inputStream, unixSocket)) {
            outputStream.close();
            throw new IOException(Gettext._("Failed to auth"));
        }
        if (null != unixSocket) {
            if (n == 1) {
                unixSocket.setBlocking(false);
            } else {
                unixSocket.setSoTimeout(n);
            }
        }
        if (null != socket) {
            socket.setSoTimeout(n);
        }
        this.mout = new MessageWriter(outputStream);
        this.min = new MessageReader(inputStream);
    }

    public void disconnect() throws IOException {
        this.min.close();
        this.mout.close();
    }

    public static class SASL {
        private static Collator col = Collator.getInstance();
        public static final int LOCK_TIMEOUT = 1000;
        public static final int NEW_KEY_TIMEOUT_SECONDS = 300;
        public static final int EXPIRE_KEYS_TIMEOUT_SECONDS = 420;
        public static final int MAX_TIME_TRAVEL_SECONDS = 300;
        public static final int COOKIE_TIMEOUT = 240;
        public static final String COOKIE_CONTEXT = "org_freedesktop_java";
        public static final int MODE_SERVER = 1;
        public static final int MODE_CLIENT = 2;
        public static final int AUTH_NONE = 0;
        public static final int AUTH_EXTERNAL = 1;
        public static final int AUTH_SHA = 2;
        public static final int AUTH_ANON = 4;
        public static final int COMMAND_AUTH = 1;
        public static final int COMMAND_DATA = 2;
        public static final int COMMAND_REJECTED = 3;
        public static final int COMMAND_OK = 4;
        public static final int COMMAND_BEGIN = 5;
        public static final int COMMAND_CANCEL = 6;
        public static final int COMMAND_ERROR = 7;
        public static final int INITIAL_STATE = 0;
        public static final int WAIT_DATA = 1;
        public static final int WAIT_OK = 2;
        public static final int WAIT_REJECT = 3;
        public static final int WAIT_AUTH = 4;
        public static final int WAIT_BEGIN = 5;
        public static final int AUTHENTICATED = 6;
        public static final int FAILED = 7;
        public static final int OK = 1;
        public static final int CONTINUE = 2;
        public static final int ERROR = 3;
        public static final int REJECT = 4;
        public String challenge = "";
        public String cookie = "";

        private String findCookie(String string, String string2) throws IOException {
            String string3 = System.getProperty("user.home");
            File file = new File(string3 + "/.dbus-keyrings/" + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String string4 = null;
            String string5 = null;
            long l = System.currentTimeMillis() / 1000L;
            while (null != (string4 = bufferedReader.readLine())) {
                String[] stringArray = string4.split(" ");
                long l2 = Long.parseLong(stringArray[1]);
                if (!stringArray[0].equals(string2) || l2 < 0L || l + 300L < l2 || l - 420L > l2) continue;
                string5 = stringArray[2];
                break;
            }
            bufferedReader.close();
            return string5;
        }

        private void addCookie(String string, String string2, long l, String string3) throws IOException {
            Closeable closeable;
            String string4 = System.getProperty("user.home");
            File file = new File(string4 + "/.dbus-keyrings/");
            File file2 = new File(string4 + "/.dbus-keyrings/" + string);
            File file3 = new File(string4 + "/.dbus-keyrings/" + string + ".lock");
            File file4 = new File(string4 + "/.dbus-keyrings/" + string + ".temp");
            if (!file.exists()) {
                file.mkdirs();
            }
            long l2 = System.currentTimeMillis();
            while (!file3.createNewFile() && 1000L > System.currentTimeMillis() - l2) {
            }
            Vector<Object> vector = new Vector<Object>();
            if (file2.exists()) {
                closeable = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
                Object object = null;
                while (null != (object = ((BufferedReader)closeable).readLine())) {
                    String[] object2 = ((String)object).split(" ");
                    long l3 = Long.parseLong(object2[1]);
                    if (l - l3 >= 240L) continue;
                    vector.add(object);
                }
                ((BufferedReader)closeable).close();
            }
            vector.add(string2 + " " + l + " " + string3);
            closeable = new PrintWriter(new FileOutputStream(file4));
            for (String string5 : vector) {
                ((PrintWriter)closeable).println(string5);
            }
            ((PrintWriter)closeable).close();
            if (!file4.renameTo(file2)) {
                file2.delete();
                file4.renameTo(file2);
            }
            file3.delete();
        }

        private String stupidlyEncode(String string) {
            return Hexdump.toHex((byte[])string.getBytes()).replaceAll(" ", "");
        }

        private String stupidlyEncode(byte[] byArray) {
            return Hexdump.toHex((byte[])byArray).replaceAll(" ", "");
        }

        private byte getNibble(char c) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return (byte)(c - 48);
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    return (byte)(c - 65 + 10);
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return (byte)(c - 97 + 10);
                }
            }
            return 0;
        }

        private String stupidlyDecode(String string) {
            char[] cArray = new char[string.length()];
            char[] cArray2 = new char[cArray.length / 2];
            string.getChars(0, string.length(), cArray, 0);
            int n = 0;
            for (int i = 0; i < cArray2.length; ++i) {
                int n2 = 0;
                n2 |= this.getNibble(cArray[n]) << 4;
                cArray2[i] = (char)(n2 |= this.getNibble(cArray[n + 1]));
                n += 2;
            }
            return new String(cArray2);
        }

        public Command receive(InputStream inputStream) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            block7: while (true) {
                int n = inputStream.read();
                switch (n) {
                    case -1: {
                        throw new IOException("Stream unexpectedly short (broken pipe)");
                    }
                    case 0: 
                    case 13: {
                        continue block7;
                    }
                    case 10: {
                        break block7;
                    }
                    default: {
                        stringBuffer.append((char)n);
                        continue block7;
                    }
                }
                break;
            }
            try {
                return new Command(stringBuffer.toString());
            }
            catch (Exception exception) {
                return new Command();
            }
        }

        public void send(OutputStream outputStream, int n, String ... stringArray) throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            switch (n) {
                case 1: {
                    stringBuffer.append("AUTH");
                    break;
                }
                case 2: {
                    stringBuffer.append("DATA");
                    break;
                }
                case 3: {
                    stringBuffer.append("REJECTED");
                    break;
                }
                case 4: {
                    stringBuffer.append("OK");
                    break;
                }
                case 5: {
                    stringBuffer.append("BEGIN");
                    break;
                }
                case 6: {
                    stringBuffer.append("CANCEL");
                    break;
                }
                case 7: {
                    stringBuffer.append("ERROR");
                    break;
                }
                default: {
                    return;
                }
            }
            for (String string : stringArray) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            }
            stringBuffer.append('\r');
            stringBuffer.append('\n');
            outputStream.write(stringBuffer.toString().getBytes());
        }

        public int do_challenge(int n, Command command) throws IOException {
            switch (n) {
                case 2: {
                    String[] stringArray = this.stupidlyDecode(command.getData()).split(" ");
                    if (3 != stringArray.length) {
                        return 3;
                    }
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    String string3 = stringArray[2];
                    MessageDigest messageDigest = null;
                    try {
                        messageDigest = MessageDigest.getInstance("SHA");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        return 3;
                    }
                    byte[] byArray = new byte[8];
                    Message.marshallintBig(System.currentTimeMillis(), byArray, 0, 8);
                    String string4 = this.stupidlyEncode(messageDigest.digest(byArray));
                    messageDigest.reset();
                    long l = System.currentTimeMillis();
                    String string5 = null;
                    while (null == string5 && System.currentTimeMillis() - l < 1000L) {
                        string5 = this.findCookie(string, string2);
                    }
                    if (null == string5) {
                        return 3;
                    }
                    String string6 = string3 + ":" + string4 + ":" + string5;
                    byArray = messageDigest.digest(string6.getBytes());
                    string6 = this.stupidlyEncode(byArray);
                    command.setResponse(this.stupidlyEncode(string4 + " " + string6));
                    return 1;
                }
            }
            return 3;
        }

        public int do_response(int n, String string, String string2, Command command) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return 3;
            }
            switch (n) {
                case 0: {
                    switch (command.getMechs()) {
                        case 4: {
                            return 1;
                        }
                        case 1: {
                            if (0 == col.compare(string, command.getData()) && (null == string2 || 0 == col.compare(string, string2))) {
                                return 1;
                            }
                            return 3;
                        }
                        case 2: {
                            String string3 = COOKIE_CONTEXT;
                            long l = System.currentTimeMillis();
                            byte[] byArray = new byte[8];
                            Message.marshallintBig(l, byArray, 0, 8);
                            this.challenge = this.stupidlyEncode(messageDigest.digest(byArray));
                            Random random = new Random();
                            random.nextBytes(byArray);
                            this.cookie = this.stupidlyEncode(messageDigest.digest(byArray));
                            try {
                                this.addCookie(string3, "" + l, l / 1000L, this.cookie);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            command.setResponse(this.stupidlyEncode(string3 + ' ' + l + ' ' + this.challenge));
                            return 2;
                        }
                    }
                    return 3;
                }
                case 2: {
                    String[] stringArray = this.stupidlyDecode(command.getData()).split(" ");
                    if (stringArray.length < 2) {
                        return 3;
                    }
                    String string4 = stringArray[0];
                    String string5 = stringArray[1];
                    String string6 = this.challenge + ":" + string4 + ":" + this.cookie;
                    byte[] byArray = messageDigest.digest(string6.getBytes());
                    String string7 = this.stupidlyEncode(byArray);
                    if (0 == col.compare(string7, string5)) {
                        return 1;
                    }
                    return 3;
                }
            }
            return 3;
        }

        public String[] getTypes(int n) {
            switch (n) {
                case 1: {
                    return new String[]{"EXTERNAL"};
                }
                case 2: {
                    return new String[]{"DBUS_COOKIE_SHA1"};
                }
                case 4: {
                    return new String[]{"ANONYMOUS"};
                }
                case 3: {
                    return new String[]{"EXTERNAL", "DBUS_COOKIE_SHA1"};
                }
                case 6: {
                    return new String[]{"ANONYMOUS", "DBUS_COOKIE_SHA1"};
                }
                case 5: {
                    return new String[]{"ANONYMOUS", "EXTERNAL"};
                }
                case 7: {
                    return new String[]{"ANONYMOUS", "EXTERNAL", "DBUS_COOKIE_SHA1"};
                }
            }
            return new String[0];
        }

        public boolean auth(int n, int n2, String string, OutputStream outputStream, InputStream inputStream, UnixSocket unixSocket) throws IOException {
            Object object;
            String string2 = System.getProperty("user.name");
            String string3 = null;
            String string4 = null;
            try {
                object = Class.forName("com.sun.security.auth.module.UnixSystem");
                Method method = ((Class)object).getMethod("getUid", new Class[0]);
                Object obj = ((Class)object).newInstance();
                long l = (Long)method.invoke(obj, new Object[0]);
                string3 = this.stupidlyEncode("" + l);
            }
            catch (Exception exception) {
                string3 = this.stupidlyEncode(string2);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            block61: while (n5 != 6 && n5 != 7) {
                switch (n) {
                    case 2: {
                        switch (n5) {
                            case 0: {
                                if (null == unixSocket) {
                                    outputStream.write(new byte[]{0});
                                } else {
                                    unixSocket.sendCredentialByte((byte)0);
                                }
                                this.send(outputStream, 1, new String[0]);
                                n5 = 1;
                                continue block61;
                            }
                            case 1: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 2: {
                                        switch (this.do_challenge(n4, (Command)object)) {
                                            case 2: {
                                                this.send(outputStream, 2, ((Command)object).getResponse());
                                                break;
                                            }
                                            case 1: {
                                                this.send(outputStream, 2, ((Command)object).getResponse());
                                                n5 = 2;
                                                break;
                                            }
                                            case 3: {
                                                this.send(outputStream, 7, ((Command)object).getResponse());
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 3: {
                                        int n6 = ((Command)object).getMechs() & ~(n3 |= n4);
                                        if (0 != (n6 & 1)) {
                                            this.send(outputStream, 1, "EXTERNAL", string3);
                                            n4 = 1;
                                            continue block61;
                                        }
                                        if (0 != (n6 & 2)) {
                                            this.send(outputStream, 1, "DBUS_COOKIE_SHA1", string3);
                                            n4 = 2;
                                            continue block61;
                                        }
                                        if (0 != (n6 & 4)) {
                                            this.send(outputStream, 1, "ANONYMOUS");
                                            n4 = 4;
                                            continue block61;
                                        }
                                        n5 = 7;
                                        continue block61;
                                    }
                                    case 7: {
                                        this.send(outputStream, 6, new String[0]);
                                        n5 = 3;
                                        continue block61;
                                    }
                                    case 4: {
                                        this.send(outputStream, 5, new String[0]);
                                        n5 = 6;
                                        continue block61;
                                    }
                                }
                                this.send(outputStream, 7, "Got invalid command");
                                continue block61;
                            }
                            case 2: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 4: {
                                        this.send(outputStream, 5, new String[0]);
                                        n5 = 6;
                                        continue block61;
                                    }
                                    case 2: 
                                    case 7: {
                                        this.send(outputStream, 6, new String[0]);
                                        n5 = 3;
                                        continue block61;
                                    }
                                    case 3: {
                                        int n7 = ((Command)object).getMechs() & ~(n3 |= n4);
                                        n5 = 1;
                                        if (0 != (n7 & 1)) {
                                            this.send(outputStream, 1, "EXTERNAL", string3);
                                            n4 = 1;
                                            continue block61;
                                        }
                                        if (0 != (n7 & 2)) {
                                            this.send(outputStream, 1, "DBUS_COOKIE_SHA1", string3);
                                            n4 = 2;
                                            continue block61;
                                        }
                                        if (0 != (n7 & 4)) {
                                            this.send(outputStream, 1, "ANONYMOUS");
                                            n4 = 4;
                                            continue block61;
                                        }
                                        n5 = 7;
                                        continue block61;
                                    }
                                }
                                this.send(outputStream, 7, "Got invalid command");
                                continue block61;
                            }
                            case 3: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 3: {
                                        int n8 = ((Command)object).getMechs() & ~(n3 |= n4);
                                        if (0 != (n8 & 1)) {
                                            this.send(outputStream, 1, "EXTERNAL", string3);
                                            n4 = 1;
                                            continue block61;
                                        }
                                        if (0 != (n8 & 2)) {
                                            this.send(outputStream, 1, "DBUS_COOKIE_SHA1", string3);
                                            n4 = 2;
                                            continue block61;
                                        }
                                        if (0 != (n8 & 4)) {
                                            this.send(outputStream, 1, "ANONYMOUS");
                                            n4 = 4;
                                            continue block61;
                                        }
                                        n5 = 7;
                                        continue block61;
                                    }
                                }
                                n5 = 7;
                                continue block61;
                            }
                        }
                        n5 = 7;
                        continue block61;
                    }
                    case 1: {
                        switch (n5) {
                            case 0: {
                                byte[] byArray = new byte[1];
                                if (null == unixSocket) {
                                    inputStream.read(byArray);
                                } else {
                                    byArray[0] = unixSocket.recvCredentialByte();
                                    int n9 = unixSocket.getPeerUID();
                                    if (n9 >= 0) {
                                        string4 = this.stupidlyEncode("" + n9);
                                    }
                                }
                                if (0 != byArray[0]) {
                                    n5 = 7;
                                    continue block61;
                                }
                                n5 = 4;
                                continue block61;
                            }
                            case 4: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 1: {
                                        if (null == ((Command)object).getData()) {
                                            this.send(outputStream, 3, this.getTypes(n2));
                                            continue block61;
                                        }
                                        switch (this.do_response(n4, string3, string4, (Command)object)) {
                                            case 2: {
                                                this.send(outputStream, 2, ((Command)object).getResponse());
                                                n4 = ((Command)object).getMechs();
                                                n5 = 1;
                                                break;
                                            }
                                            case 1: {
                                                this.send(outputStream, 4, string);
                                                n5 = 5;
                                                n4 = 0;
                                                break;
                                            }
                                            case 4: {
                                                this.send(outputStream, 3, this.getTypes(n2));
                                                n4 = 0;
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 7: {
                                        this.send(outputStream, 3, this.getTypes(n2));
                                        continue block61;
                                    }
                                    case 5: {
                                        n5 = 7;
                                        continue block61;
                                    }
                                }
                                this.send(outputStream, 7, "Got invalid command");
                                continue block61;
                            }
                            case 1: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 2: {
                                        switch (this.do_response(n4, string3, string4, (Command)object)) {
                                            case 2: {
                                                this.send(outputStream, 2, ((Command)object).getResponse());
                                                n5 = 1;
                                                break;
                                            }
                                            case 1: {
                                                this.send(outputStream, 4, string);
                                                n5 = 5;
                                                n4 = 0;
                                                break;
                                            }
                                            case 4: {
                                                this.send(outputStream, 3, this.getTypes(n2));
                                                n4 = 0;
                                            }
                                        }
                                        continue block61;
                                    }
                                    case 6: 
                                    case 7: {
                                        this.send(outputStream, 3, this.getTypes(n2));
                                        n5 = 4;
                                        continue block61;
                                    }
                                    case 5: {
                                        n5 = 7;
                                        continue block61;
                                    }
                                }
                                this.send(outputStream, 7, "Got invalid command");
                                continue block61;
                            }
                            case 5: {
                                object = this.receive(inputStream);
                                switch (((Command)object).getCommand()) {
                                    case 6: 
                                    case 7: {
                                        this.send(outputStream, 3, this.getTypes(n2));
                                        n5 = 4;
                                        continue block61;
                                    }
                                    case 5: {
                                        n5 = 6;
                                        continue block61;
                                    }
                                }
                                this.send(outputStream, 7, "Got invalid command");
                                continue block61;
                            }
                        }
                        n5 = 7;
                        continue block61;
                    }
                }
                return false;
            }
            return n5 == 6;
        }

        static {
            col.setDecomposition(2);
            col.setStrength(0);
        }

        public static class Command {
            private int command;
            private int mechs;
            private String data;
            private String response;

            public Command() {
            }

            public Command(String string) throws IOException {
                String[] stringArray = string.split(" ");
                if (0 == col.compare(stringArray[0], "OK")) {
                    this.command = 4;
                    this.data = stringArray[1];
                } else if (0 == col.compare(stringArray[0], "AUTH")) {
                    this.command = 1;
                    if (stringArray.length > 1) {
                        if (0 == col.compare(stringArray[1], "EXTERNAL")) {
                            this.mechs = 1;
                        } else if (0 == col.compare(stringArray[1], "DBUS_COOKIE_SHA1")) {
                            this.mechs = 2;
                        } else if (0 == col.compare(stringArray[1], "ANONYMOUS")) {
                            this.mechs = 4;
                        }
                    }
                    if (stringArray.length > 2) {
                        this.data = stringArray[2];
                    }
                } else if (0 == col.compare(stringArray[0], "DATA")) {
                    this.command = 2;
                    this.data = stringArray[1];
                } else if (0 == col.compare(stringArray[0], "REJECTED")) {
                    this.command = 3;
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (0 == col.compare(stringArray[i], "EXTERNAL")) {
                            this.mechs |= 1;
                            continue;
                        }
                        if (0 == col.compare(stringArray[i], "DBUS_COOKIE_SHA1")) {
                            this.mechs |= 2;
                            continue;
                        }
                        if (0 != col.compare(stringArray[i], "ANONYMOUS")) continue;
                        this.mechs |= 4;
                    }
                } else if (0 == col.compare(stringArray[0], "BEGIN")) {
                    this.command = 5;
                } else if (0 == col.compare(stringArray[0], "CANCEL")) {
                    this.command = 6;
                } else if (0 == col.compare(stringArray[0], "ERROR")) {
                    this.command = 7;
                    this.data = stringArray[1];
                } else {
                    throw new IOException(Gettext._("Invalid Command ") + stringArray[0]);
                }
            }

            public int getCommand() {
                return this.command;
            }

            public int getMechs() {
                return this.mechs;
            }

            public String getData() {
                return this.data;
            }

            public String getResponse() {
                return this.response;
            }

            public void setResponse(String string) {
                this.response = string;
            }

            public String toString() {
                return "Command(" + this.command + ", " + this.mechs + ", " + this.data + ", " + null + ")";
            }
        }
    }
}

