/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.subsystem;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jpa.subsystem.Attribute;
import org.jboss.as.jpa.subsystem.Element;
import org.jboss.as.jpa.subsystem.JPADefaultDatasourceWriteHandler;
import org.jboss.as.jpa.subsystem.JPADescriptions;
import org.jboss.as.jpa.subsystem.JPASubSystemAdd;
import org.jboss.as.jpa.subsystem.JPASubSystemRemove;
import org.jboss.as.jpa.subsystem.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JPAExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "jpa";
    private static final JPASubsystemElementParser parser = new JPASubsystemElementParser();
    private static final DescriptionProvider DESCRIPTION = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            return JPADescriptions.getSubsystemDescription(locale);
        }
    };

    private static ModelNode createAddOperation(String defaultDatasource) {
        ModelNode update = new ModelNode();
        update.get("operation").set("add");
        update.get("address").add("subsystem", SUBSYSTEM_NAME);
        update.get("default-datasource").set(defaultDatasource);
        return update;
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME);
        ManagementResourceRegistration nodeRegistration = registration.registerSubsystemModel(DESCRIPTION);
        nodeRegistration.registerOperationHandler("add", (OperationStepHandler)JPASubSystemAdd.INSTANCE, (DescriptionProvider)JPASubSystemAdd.INSTANCE, false);
        nodeRegistration.registerOperationHandler("remove", (OperationStepHandler)JPASubSystemRemove.INSTANCE, (DescriptionProvider)JPASubSystemRemove.INSTANCE, false);
        nodeRegistration.registerOperationHandler("describe", (OperationStepHandler)JPADescribeHandler.INSTANCE, (DescriptionProvider)JPADescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        nodeRegistration.registerReadWriteAttribute("default-datasource", null, (OperationStepHandler)JPADefaultDatasourceWriteHandler.INSTANCE, AttributeAccess.Storage.CONFIGURATION);
        registration.registerXMLElementWriter((XMLElementWriter)parser);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)parser);
    }

    static class JPASubsystemElementParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        JPASubsystemElementParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode subsystemAdd = null;
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case JPA: {
                        subsystemAdd = this.parseJPA(reader);
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            if (subsystemAdd == null) {
                throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.JPA.getLocalName()));
            }
            list.add(subsystemAdd);
        }

        private ModelNode parseJPA(XMLExtendedStreamReader reader) throws XMLStreamException {
            String dataSourceName = null;
            int count = reader.getAttributeCount();
            block3: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case DEFAULT_DATASOURCE_NAME: {
                        dataSourceName = value;
                        continue block3;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            if (dataSourceName == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.DEFAULT_DATASOURCE_NAME));
            }
            return JPAExtension.createAddOperation(dataSourceName);
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            ModelNode node = context.getModelNode();
            if (node.has("default-datasource")) {
                context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
                writer.writeStartElement(Element.JPA.getLocalName());
                writer.writeAttribute(Attribute.DEFAULT_DATASOURCE_NAME.getLocalName(), node.get("default-datasource").asString());
                writer.writeEndElement();
                writer.writeEndElement();
            } else {
                context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
                writer.writeEndElement();
            }
        }
    }

    private static class JPADescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final JPADescribeHandler INSTANCE = new JPADescribeHandler();

        private JPADescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            context.getResult().add(JPAExtension.createAddOperation(model.require("default-datasource").asString()));
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }
}

