/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.injectors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManagerFactory;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.jpa.service.PersistenceUnitService;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ValueManagedReference;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class PersistenceUnitInjectionSource
extends InjectionSource {
    private final PersistenceUnitJndiInjectable injectable;
    private final ServiceName puServiceName;
    private final PersistenceUnitMetadata pu;

    public PersistenceUnitInjectionSource(ServiceName puServiceName, DeploymentUnit deploymentUnit, String injectionTypeName, PersistenceUnitMetadata pu) {
        this.injectable = new PersistenceUnitJndiInjectable(puServiceName, deploymentUnit, injectionTypeName, pu);
        this.puServiceName = puServiceName;
        this.pu = pu;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) throws DeploymentUnitProcessingException {
        serviceBuilder.addDependencies(new ServiceName[]{this.puServiceName});
        injector.inject((Object)this.injectable);
    }

    public boolean equals(Object other) {
        if (other instanceof PersistenceUnitInjectionSource) {
            PersistenceUnitInjectionSource source = (PersistenceUnitInjectionSource)((Object)other);
            return source.puServiceName.equals(this.puServiceName);
        }
        return false;
    }

    public int hashCode() {
        return this.puServiceName.hashCode();
    }

    private static final class PersistenceUnitJndiInjectable
    implements ManagedReferenceFactory {
        final ServiceName puServiceName;
        final DeploymentUnit deploymentUnit;
        final String injectionTypeName;
        final PersistenceUnitMetadata pu;
        private static final String ENTITY_MANAGER_FACTORY_CLASS = "javax.persistence.EntityManagerFactory";

        public PersistenceUnitJndiInjectable(ServiceName puServiceName, DeploymentUnit deploymentUnit, String injectionTypeName, PersistenceUnitMetadata pu) {
            this.puServiceName = puServiceName;
            this.deploymentUnit = deploymentUnit;
            this.injectionTypeName = injectionTypeName;
            this.pu = pu;
        }

        public ManagedReference getReference() {
            PersistenceUnitService service = (PersistenceUnitService)this.deploymentUnit.getServiceRegistry().getRequiredService(this.puServiceName).getValue();
            EntityManagerFactory emf = service.getEntityManagerFactory();
            if (!ENTITY_MANAGER_FACTORY_CLASS.equals(this.injectionTypeName)) {
                Method getSessionFactory;
                try {
                    Class<?> extensionClass = this.pu.getClassLoader().loadClass(this.injectionTypeName);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("couldn't load " + this.injectionTypeName + " from JPA modules classloader", e);
                }
                try {
                    getSessionFactory = emf.getClass().getMethod("getSessionFactory", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Can only inject from a Hibernate EntityManagerFactoryImpl", e);
                }
                Object targetValueToInject = null;
                try {
                    targetValueToInject = getSessionFactory.invoke((Object)emf, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't get Hibernate session factory from entity manager", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Couldn't get Hibernate session factory from entity manager", e);
                }
                return new ValueManagedReference((Value)new ImmediateValue(targetValueToInject));
            }
            return new ValueManagedReference((Value)new ImmediateValue((Object)emf));
        }
    }
}

