/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class PropertiesCallbackHandler
implements Service<PropertiesCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "properties";
    private static final Class[] supportedCallbacks = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, PasswordCallback.class};
    private final String realm;
    private final String path;
    private final InjectedValue<String> relativeTo = new InjectedValue();
    private final Properties users = new Properties();

    public PropertiesCallbackHandler(String realm, ModelNode properties) {
        this.realm = realm;
        this.path = properties.require("path").asString();
    }

    public void start(StartContext context) throws StartException {
        String relativeTo = (String)this.relativeTo.getOptionalValue();
        String file = relativeTo == null ? this.path : relativeTo + "/" + this.path;
        File propertiesFile = new File(file);
        try {
            this.users.load(propertiesFile.toURI().toURL().openStream());
            String admin = "admin";
            if (this.users.contains("admin") && "admin".equals(this.users.get("admin"))) {
                Logger.getLogger((String)"org.jboss.as.domain-management").warn((Object)"Properties file defined with default user and password, this will be easy to guess.");
            }
        }
        catch (MalformedURLException mue) {
            throw new StartException("Unable to load properties", (Throwable)mue);
        }
        catch (IOException ioe) {
            throw new StartException("Unable to load properties", (Throwable)ioe);
        }
    }

    public void stop(StopContext context) {
        this.users.clear();
    }

    public PropertiesCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<String> getRelativeToInjector() {
        return this.relativeTo;
    }

    @Override
    public Class[] getSupportedCallbacks() {
        return supportedCallbacks;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        boolean userFound = false;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                userFound = this.users.containsKey(userName);
                continue;
            }
            if (current instanceof PasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw new IllegalStateException("Invalid Realm '" + realm + "' expected '" + this.realm + "'");
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                continue;
            }
            if (!(current instanceof PasswordCallback)) continue;
            if (!userFound) {
                throw new UserNotFoundException(userName);
            }
            String password = this.users.get(userName).toString();
            ((PasswordCallback)current).setPassword(password.toCharArray());
        }
    }
}

