/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.logging.Logger;
import org.xnio.ChannelThread;
import org.xnio.ChannelThreadPool;
import org.xnio.OptionMap;
import org.xnio.ReadChannelThread;
import org.xnio.WriteChannelThread;
import org.xnio.Xnio;

public final class ChannelThreadPools {
    private static final ChannelThread[] NO_THREADS = new ChannelThread[0];
    private static final Logger poolLog = Logger.getLogger((String)"org.xnio.thread-pools");

    private ChannelThreadPools() {
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createRandomPool() {
        return new Random();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createLightestLoadPool() {
        return new LightestLoad();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> createRoundRobinPool() {
        return new RoundRobin();
    }

    public static <T extends ChannelThread> ChannelThreadPool<T> singleton(T thread) {
        return new Singleton<T>(thread);
    }

    public static ChannelThreadPool<ReadChannelThread> addReadThreadsToPool(Xnio xnio, ChannelThreadPool<ReadChannelThread> pool, int count, OptionMap optionMap) throws IOException {
        return ChannelThreadPools.addReadThreadsToPool(xnio, pool, null, count, optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelThreadPool<ReadChannelThread> addReadThreadsToPool(Xnio xnio, ChannelThreadPool<ReadChannelThread> pool, ThreadGroup threadGroup, int count, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ArrayList<ReadChannelThread> threads = new ArrayList<ReadChannelThread>(count);
        try {
            for (int i = 0; i < count; ++i) {
                ReadChannelThread thread = xnio.createReadChannelThread(threadGroup, optionMap);
                threads.add(thread);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (ReadChannelThread thread : threads) {
                    thread.shutdown();
                }
            }
        }
        for (ReadChannelThread thread : threads) {
            pool.addToPool(thread);
        }
        return pool;
    }

    public static ChannelThreadPool<WriteChannelThread> addWriteThreadsToPool(Xnio xnio, ChannelThreadPool<WriteChannelThread> pool, int count, OptionMap optionMap) throws IOException {
        return ChannelThreadPools.addWriteThreadsToPool(xnio, pool, null, count, optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelThreadPool<WriteChannelThread> addWriteThreadsToPool(Xnio xnio, ChannelThreadPool<WriteChannelThread> pool, ThreadGroup threadGroup, int count, OptionMap optionMap) throws IOException {
        boolean ok = false;
        ArrayList<WriteChannelThread> threads = new ArrayList<WriteChannelThread>(count);
        try {
            for (int i = 0; i < count; ++i) {
                WriteChannelThread thread = xnio.createWriteChannelThread(threadGroup, optionMap);
                threads.add(thread);
            }
            ok = true;
        }
        finally {
            if (!ok) {
                for (WriteChannelThread thread : threads) {
                    thread.shutdown();
                }
            }
        }
        for (WriteChannelThread thread : threads) {
            pool.addToPool(thread);
        }
        return pool;
    }

    public static void shutdown(ChannelThreadPool<?> pool) {
        Object thread;
        while ((thread = pool.getThread()) != null) {
            thread.shutdown();
        }
    }

    static /* synthetic */ ChannelThread[] access$300() {
        return NO_THREADS;
    }

    private static class Singleton<T extends ChannelThread>
    implements ChannelThreadPool<T> {
        private final T thread;

        Singleton(T thread) {
            this.thread = thread;
        }

        @Override
        public T getThread() {
            poolLog.tracef("Returning thread %s from pool %s", this.thread, (Object)this);
            return this.thread;
        }

        @Override
        public void addToPool(T thread) {
            throw new IllegalArgumentException("Pool is full");
        }
    }

    private static class Random<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private final java.util.Random random;

        Random() {
            this(new java.util.Random());
        }

        Random(java.util.Random random) {
            this.random = random;
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            ChannelThread thread = pool[this.random.nextInt(len)];
            poolLog.tracef("Returning thread %s from pool %s", (Object)thread, (Object)this);
            return (T)thread;
        }
    }

    private static class LightestLoad<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private LightestLoad() {
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            int best = Integer.MAX_VALUE;
            int bestIdx = -1;
            for (int i = 0; i < len; ++i) {
                int load = pool[i].getLoad();
                if (load >= best) continue;
                bestIdx = i;
            }
            ChannelThread thread = pool[bestIdx];
            poolLog.tracef("Returning thread %s from pool %s", (Object)thread, (Object)this);
            return (T)thread;
        }
    }

    private static class RoundRobin<T extends ChannelThread>
    extends SimpleThreadPool<T> {
        private volatile int idx;
        private static final AtomicIntegerFieldUpdater<RoundRobin> idxUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobin.class, "idx");

        private RoundRobin() {
        }

        @Override
        public T getThread() {
            ChannelThread[] pool = this.pool;
            int len = pool.length;
            if (len == 0) {
                return null;
            }
            return (T)pool[idxUpdater.getAndIncrement(this) % len];
        }
    }

    private static abstract class SimpleThreadPool<T extends ChannelThread>
    implements ChannelThreadPool<T> {
        private final Set<T> threadSet = new HashSet<T>();
        private final ChannelThread.Listener listener = new ChannelThread.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleTerminationInitiated(ChannelThread thread) {
                Set threadSet;
                thread.removeTerminationListener(this);
                Set set = threadSet = SimpleThreadPool.this.threadSet;
                synchronized (set) {
                    if (threadSet.remove(thread)) {
                        SimpleThreadPool.this.pool = threadSet.toArray(new ChannelThread[threadSet.size()]);
                    }
                }
            }

            @Override
            public void handleTerminationComplete(ChannelThread thread) {
            }
        };
        volatile T[] pool = ChannelThreadPools.access$300();

        private SimpleThreadPool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addToPool(T thread) {
            Set<T> threadSet;
            poolLog.tracef("Adding thread %s to pool %s", thread, (Object)this);
            Set<T> set = threadSet = this.threadSet;
            synchronized (set) {
                if (threadSet.add(thread)) {
                    T[] pool = this.pool;
                    int oldLen = pool.length;
                    ChannelThread[] newPool = (ChannelThread[])Arrays.copyOf(pool, oldLen + 1);
                    newPool[oldLen] = thread;
                    thread.addTerminationListener(this.listener);
                    this.pool = newPool;
                }
            }
        }
    }
}

