/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.oracle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.spi.ValidConnectionChecker;
import org.jboss.logging.Logger;

public class OracleValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 5379340663276548636L;
    private static transient Logger log;
    private Integer pingTimeOut = new Integer(5);
    private transient Method ping;

    public OracleValidConnectionChecker() {
        try {
            this.initPing();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to resolve pingDatabase method:", e);
        }
    }

    @Override
    public SQLException isValidConnection(Connection c) {
        Object[] params = new Object[]{this.pingTimeOut};
        try {
            Integer status = (Integer)this.ping.invoke((Object)c, params);
            if (status == null || status < 0) {
                return new SQLException("pingDatabase failed status=" + status);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unexpected error in pingDatabase", (Throwable)e);
        }
        return null;
    }

    private void initPing() throws ClassNotFoundException, NoSuchMethodException {
        log = Logger.getLogger(OracleValidConnectionChecker.class);
        Class<?> oracleConnection = Class.forName("oracle.jdbc.driver.OracleConnection", true, this.getClass().getClassLoader());
        this.ping = oracleConnection.getMethod("pingDatabase", Integer.TYPE);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            this.initPing();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to resolve pingDatabase method: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public final Integer getPingTimeOut() {
        return this.pingTimeOut;
    }

    public final void setPingTimeOut(Integer pingTimeOut) {
        this.pingTimeOut = pingTimeOut;
    }
}

